/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TicketReply.Builder.class)
public final class TicketReply {
    private final String id;

    private final PartType partType;

    private final Optional<String> body;

    private final int createdAt;

    private final Optional<Integer> updatedAt;

    private final Optional<TicketPartAuthor> author;

    private final Optional<List<PartAttachment>> attachments;

    private final Optional<Boolean> redacted;

    private final Map<String, Object> additionalProperties;

    private TicketReply(
            String id,
            PartType partType,
            Optional<String> body,
            int createdAt,
            Optional<Integer> updatedAt,
            Optional<TicketPartAuthor> author,
            Optional<List<PartAttachment>> attachments,
            Optional<Boolean> redacted,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.partType = partType;
        this.body = body;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.author = author;
        this.attachments = attachments;
        this.redacted = redacted;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Always ticket_part
     */
    @JsonProperty("type")
    public String getType() {
        return "ticket_part";
    }

    /**
     * @return The id representing the part.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return Type of the part
     */
    @JsonProperty("part_type")
    public PartType getPartType() {
        return partType;
    }

    /**
     * @return The message body, which may contain HTML.
     */
    @JsonProperty("body")
    public Optional<String> getBody() {
        return body;
    }

    /**
     * @return The time the note was created.
     */
    @JsonProperty("created_at")
    public int getCreatedAt() {
        return createdAt;
    }

    /**
     * @return The last time the note was updated.
     */
    @JsonProperty("updated_at")
    public Optional<Integer> getUpdatedAt() {
        return updatedAt;
    }

    @JsonProperty("author")
    public Optional<TicketPartAuthor> getAuthor() {
        return author;
    }

    /**
     * @return A list of attachments for the part.
     */
    @JsonProperty("attachments")
    public Optional<List<PartAttachment>> getAttachments() {
        return attachments;
    }

    /**
     * @return Whether or not the ticket part has been redacted.
     */
    @JsonProperty("redacted")
    public Optional<Boolean> getRedacted() {
        return redacted;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TicketReply && equalTo((TicketReply) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TicketReply other) {
        return id.equals(other.id)
                && partType.equals(other.partType)
                && body.equals(other.body)
                && createdAt == other.createdAt
                && updatedAt.equals(other.updatedAt)
                && author.equals(other.author)
                && attachments.equals(other.attachments)
                && redacted.equals(other.redacted);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.id,
                this.partType,
                this.body,
                this.createdAt,
                this.updatedAt,
                this.author,
                this.attachments,
                this.redacted);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * The id representing the part.
         */
        PartTypeStage id(@NotNull String id);

        Builder from(TicketReply other);
    }

    public interface PartTypeStage {
        /**
         * Type of the part
         */
        CreatedAtStage partType(@NotNull PartType partType);
    }

    public interface CreatedAtStage {
        /**
         * The time the note was created.
         */
        _FinalStage createdAt(int createdAt);
    }

    public interface _FinalStage {
        TicketReply build();

        /**
         * <p>The message body, which may contain HTML.</p>
         */
        _FinalStage body(Optional<String> body);

        _FinalStage body(String body);

        /**
         * <p>The last time the note was updated.</p>
         */
        _FinalStage updatedAt(Optional<Integer> updatedAt);

        _FinalStage updatedAt(Integer updatedAt);

        _FinalStage author(Optional<TicketPartAuthor> author);

        _FinalStage author(TicketPartAuthor author);

        /**
         * <p>A list of attachments for the part.</p>
         */
        _FinalStage attachments(Optional<List<PartAttachment>> attachments);

        _FinalStage attachments(List<PartAttachment> attachments);

        /**
         * <p>Whether or not the ticket part has been redacted.</p>
         */
        _FinalStage redacted(Optional<Boolean> redacted);

        _FinalStage redacted(Boolean redacted);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, PartTypeStage, CreatedAtStage, _FinalStage {
        private String id;

        private PartType partType;

        private int createdAt;

        private Optional<Boolean> redacted = Optional.empty();

        private Optional<List<PartAttachment>> attachments = Optional.empty();

        private Optional<TicketPartAuthor> author = Optional.empty();

        private Optional<Integer> updatedAt = Optional.empty();

        private Optional<String> body = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(TicketReply other) {
            id(other.getId());
            partType(other.getPartType());
            body(other.getBody());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            author(other.getAuthor());
            attachments(other.getAttachments());
            redacted(other.getRedacted());
            return this;
        }

        /**
         * The id representing the part.<p>The id representing the part.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public PartTypeStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * Type of the part<p>Type of the part</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("part_type")
        public CreatedAtStage partType(@NotNull PartType partType) {
            this.partType = Objects.requireNonNull(partType, "partType must not be null");
            return this;
        }

        /**
         * The time the note was created.<p>The time the note was created.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_at")
        public _FinalStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        /**
         * <p>Whether or not the ticket part has been redacted.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage redacted(Boolean redacted) {
            this.redacted = Optional.ofNullable(redacted);
            return this;
        }

        /**
         * <p>Whether or not the ticket part has been redacted.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "redacted", nulls = Nulls.SKIP)
        public _FinalStage redacted(Optional<Boolean> redacted) {
            this.redacted = redacted;
            return this;
        }

        /**
         * <p>A list of attachments for the part.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage attachments(List<PartAttachment> attachments) {
            this.attachments = Optional.ofNullable(attachments);
            return this;
        }

        /**
         * <p>A list of attachments for the part.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "attachments", nulls = Nulls.SKIP)
        public _FinalStage attachments(Optional<List<PartAttachment>> attachments) {
            this.attachments = attachments;
            return this;
        }

        @java.lang.Override
        public _FinalStage author(TicketPartAuthor author) {
            this.author = Optional.ofNullable(author);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "author", nulls = Nulls.SKIP)
        public _FinalStage author(Optional<TicketPartAuthor> author) {
            this.author = author;
            return this;
        }

        /**
         * <p>The last time the note was updated.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        /**
         * <p>The last time the note was updated.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "updated_at", nulls = Nulls.SKIP)
        public _FinalStage updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        /**
         * <p>The message body, which may contain HTML.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        /**
         * <p>The message body, which may contain HTML.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "body", nulls = Nulls.SKIP)
        public _FinalStage body(Optional<String> body) {
            this.body = body;
            return this;
        }

        @java.lang.Override
        public TicketReply build() {
            return new TicketReply(
                    id, partType, body, createdAt, updatedAt, author, attachments, redacted, additionalProperties);
        }
    }

    public static final class PartType {
        public static final PartType NOTE = new PartType(Value.NOTE, "note");

        public static final PartType QUICK_REPLY = new PartType(Value.QUICK_REPLY, "quick_reply");

        public static final PartType COMMENT = new PartType(Value.COMMENT, "comment");

        private final Value value;

        private final String string;

        PartType(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof PartType && this.string.equals(((PartType) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case NOTE:
                    return visitor.visitNote();
                case QUICK_REPLY:
                    return visitor.visitQuickReply();
                case COMMENT:
                    return visitor.visitComment();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static PartType valueOf(String value) {
            switch (value) {
                case "note":
                    return NOTE;
                case "quick_reply":
                    return QUICK_REPLY;
                case "comment":
                    return COMMENT;
                default:
                    return new PartType(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            NOTE,

            COMMENT,

            QUICK_REPLY,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitNote();

            T visitComment();

            T visitQuickReply();

            T visitUnknown(String unknownType);
        }
    }
}
