/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TicketTypeAttribute.Builder.class)
public final class TicketTypeAttribute {
    private final String id;

    private final String workspaceId;

    private final String name;

    private final String description;

    private final DataType dataType;

    private final Map<String, Object> inputOptions;

    private final int order;

    private final boolean requiredToCreate;

    private final boolean requiredToCreateForContacts;

    private final boolean visibleOnCreate;

    private final boolean visibleToContacts;

    private final boolean default_;

    private final int ticketTypeId;

    private final boolean archived;

    private final int createdAt;

    private final Optional<Integer> updatedAt;

    private final Map<String, Object> additionalProperties;

    private TicketTypeAttribute(
            String id,
            String workspaceId,
            String name,
            String description,
            DataType dataType,
            Map<String, Object> inputOptions,
            int order,
            boolean requiredToCreate,
            boolean requiredToCreateForContacts,
            boolean visibleOnCreate,
            boolean visibleToContacts,
            boolean default_,
            int ticketTypeId,
            boolean archived,
            int createdAt,
            Optional<Integer> updatedAt,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.workspaceId = workspaceId;
        this.name = name;
        this.description = description;
        this.dataType = dataType;
        this.inputOptions = inputOptions;
        this.order = order;
        this.requiredToCreate = requiredToCreate;
        this.requiredToCreateForContacts = requiredToCreateForContacts;
        this.visibleOnCreate = visibleOnCreate;
        this.visibleToContacts = visibleToContacts;
        this.default_ = default_;
        this.ticketTypeId = ticketTypeId;
        this.archived = archived;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return String representing the object's type. Always has the value <code>ticket_type_attribute</code>.
     */
    @JsonProperty("type")
    public String getType() {
        return "ticket_type_attribute";
    }

    /**
     * @return The id representing the ticket type attribute.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The id of the workspace that the ticket type attribute belongs to.
     */
    @JsonProperty("workspace_id")
    public String getWorkspaceId() {
        return workspaceId;
    }

    /**
     * @return The name of the ticket type attribute
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * @return The description of the ticket type attribute
     */
    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    /**
     * @return The type of the data attribute (allowed values: &quot;string list integer decimal boolean datetime files&quot;)
     */
    @JsonProperty("data_type")
    public DataType getDataType() {
        return dataType;
    }

    /**
     * @return Input options for the attribute
     */
    @JsonProperty("input_options")
    public Map<String, Object> getInputOptions() {
        return inputOptions;
    }

    /**
     * @return The order of the attribute against other attributes
     */
    @JsonProperty("order")
    public int getOrder() {
        return order;
    }

    /**
     * @return Whether the attribute is required or not for teammates.
     */
    @JsonProperty("required_to_create")
    public boolean getRequiredToCreate() {
        return requiredToCreate;
    }

    /**
     * @return Whether the attribute is required or not for contacts.
     */
    @JsonProperty("required_to_create_for_contacts")
    public boolean getRequiredToCreateForContacts() {
        return requiredToCreateForContacts;
    }

    /**
     * @return Whether the attribute is visible or not to teammates.
     */
    @JsonProperty("visible_on_create")
    public boolean getVisibleOnCreate() {
        return visibleOnCreate;
    }

    /**
     * @return Whether the attribute is visible or not to contacts.
     */
    @JsonProperty("visible_to_contacts")
    public boolean getVisibleToContacts() {
        return visibleToContacts;
    }

    /**
     * @return Whether the attribute is built in or not.
     */
    @JsonProperty("default")
    public boolean getDefault() {
        return default_;
    }

    /**
     * @return The id of the ticket type that the attribute belongs to.
     */
    @JsonProperty("ticket_type_id")
    public int getTicketTypeId() {
        return ticketTypeId;
    }

    /**
     * @return Whether the ticket type attribute is archived or not.
     */
    @JsonProperty("archived")
    public boolean getArchived() {
        return archived;
    }

    /**
     * @return The date and time the ticket type attribute was created.
     */
    @JsonProperty("created_at")
    public int getCreatedAt() {
        return createdAt;
    }

    /**
     * @return The date and time the ticket type attribute was last updated.
     */
    @JsonProperty("updated_at")
    public Optional<Integer> getUpdatedAt() {
        return updatedAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TicketTypeAttribute && equalTo((TicketTypeAttribute) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TicketTypeAttribute other) {
        return id.equals(other.id)
                && workspaceId.equals(other.workspaceId)
                && name.equals(other.name)
                && description.equals(other.description)
                && dataType.equals(other.dataType)
                && inputOptions.equals(other.inputOptions)
                && order == other.order
                && requiredToCreate == other.requiredToCreate
                && requiredToCreateForContacts == other.requiredToCreateForContacts
                && visibleOnCreate == other.visibleOnCreate
                && visibleToContacts == other.visibleToContacts
                && default_ == other.default_
                && ticketTypeId == other.ticketTypeId
                && archived == other.archived
                && createdAt == other.createdAt
                && updatedAt.equals(other.updatedAt);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.id,
                this.workspaceId,
                this.name,
                this.description,
                this.dataType,
                this.inputOptions,
                this.order,
                this.requiredToCreate,
                this.requiredToCreateForContacts,
                this.visibleOnCreate,
                this.visibleToContacts,
                this.default_,
                this.ticketTypeId,
                this.archived,
                this.createdAt,
                this.updatedAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * The id representing the ticket type attribute.
         */
        WorkspaceIdStage id(@NotNull String id);

        Builder from(TicketTypeAttribute other);
    }

    public interface WorkspaceIdStage {
        /**
         * The id of the workspace that the ticket type attribute belongs to.
         */
        NameStage workspaceId(@NotNull String workspaceId);
    }

    public interface NameStage {
        /**
         * The name of the ticket type attribute
         */
        DescriptionStage name(@NotNull String name);
    }

    public interface DescriptionStage {
        /**
         * The description of the ticket type attribute
         */
        DataTypeStage description(@NotNull String description);
    }

    public interface DataTypeStage {
        /**
         * The type of the data attribute (allowed values: "string list integer decimal boolean datetime files")
         */
        OrderStage dataType(@NotNull DataType dataType);
    }

    public interface OrderStage {
        /**
         * The order of the attribute against other attributes
         */
        RequiredToCreateStage order(int order);
    }

    public interface RequiredToCreateStage {
        /**
         * Whether the attribute is required or not for teammates.
         */
        RequiredToCreateForContactsStage requiredToCreate(boolean requiredToCreate);
    }

    public interface RequiredToCreateForContactsStage {
        /**
         * Whether the attribute is required or not for contacts.
         */
        VisibleOnCreateStage requiredToCreateForContacts(boolean requiredToCreateForContacts);
    }

    public interface VisibleOnCreateStage {
        /**
         * Whether the attribute is visible or not to teammates.
         */
        VisibleToContactsStage visibleOnCreate(boolean visibleOnCreate);
    }

    public interface VisibleToContactsStage {
        /**
         * Whether the attribute is visible or not to contacts.
         */
        DefaultStage visibleToContacts(boolean visibleToContacts);
    }

    public interface DefaultStage {
        /**
         * Whether the attribute is built in or not.
         */
        TicketTypeIdStage default_(boolean default_);
    }

    public interface TicketTypeIdStage {
        /**
         * The id of the ticket type that the attribute belongs to.
         */
        ArchivedStage ticketTypeId(int ticketTypeId);
    }

    public interface ArchivedStage {
        /**
         * Whether the ticket type attribute is archived or not.
         */
        CreatedAtStage archived(boolean archived);
    }

    public interface CreatedAtStage {
        /**
         * The date and time the ticket type attribute was created.
         */
        _FinalStage createdAt(int createdAt);
    }

    public interface _FinalStage {
        TicketTypeAttribute build();

        /**
         * <p>Input options for the attribute</p>
         */
        _FinalStage inputOptions(Map<String, Object> inputOptions);

        _FinalStage putAllInputOptions(Map<String, Object> inputOptions);

        _FinalStage inputOptions(String key, Object value);

        /**
         * <p>The date and time the ticket type attribute was last updated.</p>
         */
        _FinalStage updatedAt(Optional<Integer> updatedAt);

        _FinalStage updatedAt(Integer updatedAt);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements IdStage,
                    WorkspaceIdStage,
                    NameStage,
                    DescriptionStage,
                    DataTypeStage,
                    OrderStage,
                    RequiredToCreateStage,
                    RequiredToCreateForContactsStage,
                    VisibleOnCreateStage,
                    VisibleToContactsStage,
                    DefaultStage,
                    TicketTypeIdStage,
                    ArchivedStage,
                    CreatedAtStage,
                    _FinalStage {
        private String id;

        private String workspaceId;

        private String name;

        private String description;

        private DataType dataType;

        private int order;

        private boolean requiredToCreate;

        private boolean requiredToCreateForContacts;

        private boolean visibleOnCreate;

        private boolean visibleToContacts;

        private boolean default_;

        private int ticketTypeId;

        private boolean archived;

        private int createdAt;

        private Optional<Integer> updatedAt = Optional.empty();

        private Map<String, Object> inputOptions = new LinkedHashMap<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(TicketTypeAttribute other) {
            id(other.getId());
            workspaceId(other.getWorkspaceId());
            name(other.getName());
            description(other.getDescription());
            dataType(other.getDataType());
            inputOptions(other.getInputOptions());
            order(other.getOrder());
            requiredToCreate(other.getRequiredToCreate());
            requiredToCreateForContacts(other.getRequiredToCreateForContacts());
            visibleOnCreate(other.getVisibleOnCreate());
            visibleToContacts(other.getVisibleToContacts());
            default_(other.getDefault());
            ticketTypeId(other.getTicketTypeId());
            archived(other.getArchived());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            return this;
        }

        /**
         * The id representing the ticket type attribute.<p>The id representing the ticket type attribute.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public WorkspaceIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * The id of the workspace that the ticket type attribute belongs to.<p>The id of the workspace that the ticket type attribute belongs to.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("workspace_id")
        public NameStage workspaceId(@NotNull String workspaceId) {
            this.workspaceId = Objects.requireNonNull(workspaceId, "workspaceId must not be null");
            return this;
        }

        /**
         * The name of the ticket type attribute<p>The name of the ticket type attribute</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("name")
        public DescriptionStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        /**
         * The description of the ticket type attribute<p>The description of the ticket type attribute</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("description")
        public DataTypeStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        /**
         * The type of the data attribute (allowed values: "string list integer decimal boolean datetime files")<p>The type of the data attribute (allowed values: &quot;string list integer decimal boolean datetime files&quot;)</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("data_type")
        public OrderStage dataType(@NotNull DataType dataType) {
            this.dataType = Objects.requireNonNull(dataType, "dataType must not be null");
            return this;
        }

        /**
         * The order of the attribute against other attributes<p>The order of the attribute against other attributes</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("order")
        public RequiredToCreateStage order(int order) {
            this.order = order;
            return this;
        }

        /**
         * Whether the attribute is required or not for teammates.<p>Whether the attribute is required or not for teammates.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("required_to_create")
        public RequiredToCreateForContactsStage requiredToCreate(boolean requiredToCreate) {
            this.requiredToCreate = requiredToCreate;
            return this;
        }

        /**
         * Whether the attribute is required or not for contacts.<p>Whether the attribute is required or not for contacts.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("required_to_create_for_contacts")
        public VisibleOnCreateStage requiredToCreateForContacts(boolean requiredToCreateForContacts) {
            this.requiredToCreateForContacts = requiredToCreateForContacts;
            return this;
        }

        /**
         * Whether the attribute is visible or not to teammates.<p>Whether the attribute is visible or not to teammates.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("visible_on_create")
        public VisibleToContactsStage visibleOnCreate(boolean visibleOnCreate) {
            this.visibleOnCreate = visibleOnCreate;
            return this;
        }

        /**
         * Whether the attribute is visible or not to contacts.<p>Whether the attribute is visible or not to contacts.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("visible_to_contacts")
        public DefaultStage visibleToContacts(boolean visibleToContacts) {
            this.visibleToContacts = visibleToContacts;
            return this;
        }

        /**
         * Whether the attribute is built in or not.<p>Whether the attribute is built in or not.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("default")
        public TicketTypeIdStage default_(boolean default_) {
            this.default_ = default_;
            return this;
        }

        /**
         * The id of the ticket type that the attribute belongs to.<p>The id of the ticket type that the attribute belongs to.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("ticket_type_id")
        public ArchivedStage ticketTypeId(int ticketTypeId) {
            this.ticketTypeId = ticketTypeId;
            return this;
        }

        /**
         * Whether the ticket type attribute is archived or not.<p>Whether the ticket type attribute is archived or not.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("archived")
        public CreatedAtStage archived(boolean archived) {
            this.archived = archived;
            return this;
        }

        /**
         * The date and time the ticket type attribute was created.<p>The date and time the ticket type attribute was created.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_at")
        public _FinalStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        /**
         * <p>The date and time the ticket type attribute was last updated.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        /**
         * <p>The date and time the ticket type attribute was last updated.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "updated_at", nulls = Nulls.SKIP)
        public _FinalStage updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        /**
         * <p>Input options for the attribute</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage inputOptions(String key, Object value) {
            this.inputOptions.put(key, value);
            return this;
        }

        /**
         * <p>Input options for the attribute</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage putAllInputOptions(Map<String, Object> inputOptions) {
            this.inputOptions.putAll(inputOptions);
            return this;
        }

        /**
         * <p>Input options for the attribute</p>
         */
        @java.lang.Override
        @JsonSetter(value = "input_options", nulls = Nulls.SKIP)
        public _FinalStage inputOptions(Map<String, Object> inputOptions) {
            this.inputOptions.clear();
            this.inputOptions.putAll(inputOptions);
            return this;
        }

        @java.lang.Override
        public TicketTypeAttribute build() {
            return new TicketTypeAttribute(
                    id,
                    workspaceId,
                    name,
                    description,
                    dataType,
                    inputOptions,
                    order,
                    requiredToCreate,
                    requiredToCreateForContacts,
                    visibleOnCreate,
                    visibleToContacts,
                    default_,
                    ticketTypeId,
                    archived,
                    createdAt,
                    updatedAt,
                    additionalProperties);
        }
    }

    public static final class DataType {
        public static final DataType STRING = new DataType(Value.STRING, "string");

        public static final DataType DECIMAL = new DataType(Value.DECIMAL, "decimal");

        public static final DataType LIST = new DataType(Value.LIST, "list");

        public static final DataType INTEGER = new DataType(Value.INTEGER, "integer");

        public static final DataType DATETIME = new DataType(Value.DATETIME, "datetime");

        public static final DataType BOOLEAN = new DataType(Value.BOOLEAN, "boolean");

        public static final DataType FILES = new DataType(Value.FILES, "files");

        private final Value value;

        private final String string;

        DataType(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof DataType && this.string.equals(((DataType) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case STRING:
                    return visitor.visitString();
                case DECIMAL:
                    return visitor.visitDecimal();
                case LIST:
                    return visitor.visitList();
                case INTEGER:
                    return visitor.visitInteger();
                case DATETIME:
                    return visitor.visitDatetime();
                case BOOLEAN:
                    return visitor.visitBoolean();
                case FILES:
                    return visitor.visitFiles();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static DataType valueOf(String value) {
            switch (value) {
                case "string":
                    return STRING;
                case "decimal":
                    return DECIMAL;
                case "list":
                    return LIST;
                case "integer":
                    return INTEGER;
                case "datetime":
                    return DATETIME;
                case "boolean":
                    return BOOLEAN;
                case "files":
                    return FILES;
                default:
                    return new DataType(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            STRING,

            LIST,

            INTEGER,

            DECIMAL,

            BOOLEAN,

            DATETIME,

            FILES,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitString();

            T visitList();

            T visitInteger();

            T visitDecimal();

            T visitBoolean();

            T visitDatetime();

            T visitFiles();

            T visitUnknown(String unknownType);
        }
    }
}
