/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UntagCompanyRequest.Builder.class)
public final class UntagCompanyRequest {
    private final String name;

    private final List<CompaniesItem> companies;

    private final Map<String, Object> additionalProperties;

    private UntagCompanyRequest(String name, List<CompaniesItem> companies, Map<String, Object> additionalProperties) {
        this.name = name;
        this.companies = companies;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The name of the tag which will be untagged from the company
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * @return The id or company_id of the company can be passed as input parameters.
     */
    @JsonProperty("companies")
    public List<CompaniesItem> getCompanies() {
        return companies;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UntagCompanyRequest && equalTo((UntagCompanyRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UntagCompanyRequest other) {
        return name.equals(other.name) && companies.equals(other.companies);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.name, this.companies);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    public interface NameStage {
        /**
         * The name of the tag which will be untagged from the company
         */
        _FinalStage name(@NotNull String name);

        Builder from(UntagCompanyRequest other);
    }

    public interface _FinalStage {
        UntagCompanyRequest build();

        /**
         * <p>The id or company_id of the company can be passed as input parameters.</p>
         */
        _FinalStage companies(List<CompaniesItem> companies);

        _FinalStage addCompanies(CompaniesItem companies);

        _FinalStage addAllCompanies(List<CompaniesItem> companies);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements NameStage, _FinalStage {
        private String name;

        private List<CompaniesItem> companies = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(UntagCompanyRequest other) {
            name(other.getName());
            companies(other.getCompanies());
            return this;
        }

        /**
         * The name of the tag which will be untagged from the company<p>The name of the tag which will be untagged from the company</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        /**
         * <p>The id or company_id of the company can be passed as input parameters.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addAllCompanies(List<CompaniesItem> companies) {
            this.companies.addAll(companies);
            return this;
        }

        /**
         * <p>The id or company_id of the company can be passed as input parameters.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addCompanies(CompaniesItem companies) {
            this.companies.add(companies);
            return this;
        }

        /**
         * <p>The id or company_id of the company can be passed as input parameters.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "companies", nulls = Nulls.SKIP)
        public _FinalStage companies(List<CompaniesItem> companies) {
            this.companies.clear();
            this.companies.addAll(companies);
            return this;
        }

        @java.lang.Override
        public UntagCompanyRequest build() {
            return new UntagCompanyRequest(name, companies, additionalProperties);
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = CompaniesItem.Builder.class)
    public static final class CompaniesItem {
        private final String id;

        private final String companyId;

        private final Map<String, Object> additionalProperties;

        private CompaniesItem(String id, String companyId, Map<String, Object> additionalProperties) {
            this.id = id;
            this.companyId = companyId;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The Intercom defined id representing the company.
         */
        @JsonProperty("id")
        public String getId() {
            return id;
        }

        /**
         * @return The company id you have defined for the company.
         */
        @JsonProperty("company_id")
        public String getCompanyId() {
            return companyId;
        }

        /**
         * @return Always set to true
         */
        @JsonProperty("untag")
        public Boolean getUntag() {
            return true;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof CompaniesItem && equalTo((CompaniesItem) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(CompaniesItem other) {
            return id.equals(other.id) && companyId.equals(other.companyId);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.id, this.companyId);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static IdStage builder() {
            return new Builder();
        }

        public interface IdStage {
            /**
             * The Intercom defined id representing the company.
             */
            CompanyIdStage id(@NotNull String id);

            Builder from(CompaniesItem other);
        }

        public interface CompanyIdStage {
            /**
             * The company id you have defined for the company.
             */
            _FinalStage companyId(@NotNull String companyId);
        }

        public interface _FinalStage {
            CompaniesItem build();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder implements IdStage, CompanyIdStage, _FinalStage {
            private String id;

            private String companyId;

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            @java.lang.Override
            public Builder from(CompaniesItem other) {
                id(other.getId());
                companyId(other.getCompanyId());
                return this;
            }

            /**
             * The Intercom defined id representing the company.<p>The Intercom defined id representing the company.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("id")
            public CompanyIdStage id(@NotNull String id) {
                this.id = Objects.requireNonNull(id, "id must not be null");
                return this;
            }

            /**
             * The company id you have defined for the company.<p>The company id you have defined for the company.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("company_id")
            public _FinalStage companyId(@NotNull String companyId) {
                this.companyId = Objects.requireNonNull(companyId, "companyId must not be null");
                return this;
            }

            @java.lang.Override
            public CompaniesItem build() {
                return new CompaniesItem(id, companyId, additionalProperties);
            }
        }
    }
}
