/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api;

import com.intercom.api.IntercomBuilder;
import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.Suppliers;
import com.intercom.api.resources.admins.AdminsClient;
import com.intercom.api.resources.articles.ArticlesClient;
import com.intercom.api.resources.companies.CompaniesClient;
import com.intercom.api.resources.contacts.ContactsClient;
import com.intercom.api.resources.conversations.ConversationsClient;
import com.intercom.api.resources.dataattributes.DataAttributesClient;
import com.intercom.api.resources.dataexport.DataExportClient;
import com.intercom.api.resources.events.EventsClient;
import com.intercom.api.resources.helpcenters.HelpCentersClient;
import com.intercom.api.resources.messages.MessagesClient;
import com.intercom.api.resources.news.NewsClient;
import com.intercom.api.resources.notes.NotesClient;
import com.intercom.api.resources.phonecallredirects.PhoneCallRedirectsClient;
import com.intercom.api.resources.segments.SegmentsClient;
import com.intercom.api.resources.subscriptiontypes.SubscriptionTypesClient;
import com.intercom.api.resources.tags.TagsClient;
import com.intercom.api.resources.teams.TeamsClient;
import com.intercom.api.resources.tickets.TicketsClient;
import com.intercom.api.resources.tickettypes.TicketTypesClient;
import com.intercom.api.resources.unstable.UnstableClient;
import com.intercom.api.resources.visitors.VisitorsClient;
import java.util.function.Supplier;

public class Intercom {
    protected final ClientOptions clientOptions;
    protected final Supplier<AdminsClient> adminsClient;
    protected final Supplier<ArticlesClient> articlesClient;
    protected final Supplier<HelpCentersClient> helpCentersClient;
    protected final Supplier<CompaniesClient> companiesClient;
    protected final Supplier<ContactsClient> contactsClient;
    protected final Supplier<NotesClient> notesClient;
    protected final Supplier<TagsClient> tagsClient;
    protected final Supplier<ConversationsClient> conversationsClient;
    protected final Supplier<DataAttributesClient> dataAttributesClient;
    protected final Supplier<EventsClient> eventsClient;
    protected final Supplier<DataExportClient> dataExportClient;
    protected final Supplier<MessagesClient> messagesClient;
    protected final Supplier<SegmentsClient> segmentsClient;
    protected final Supplier<SubscriptionTypesClient> subscriptionTypesClient;
    protected final Supplier<PhoneCallRedirectsClient> phoneCallRedirectsClient;
    protected final Supplier<TeamsClient> teamsClient;
    protected final Supplier<TicketTypesClient> ticketTypesClient;
    protected final Supplier<TicketsClient> ticketsClient;
    protected final Supplier<VisitorsClient> visitorsClient;
    protected final Supplier<NewsClient> newsClient;
    protected final Supplier<UnstableClient> unstableClient;

    public Intercom(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.adminsClient = Suppliers.memoize(() -> new AdminsClient(clientOptions));
        this.articlesClient = Suppliers.memoize(() -> new ArticlesClient(clientOptions));
        this.helpCentersClient = Suppliers.memoize(() -> new HelpCentersClient(clientOptions));
        this.companiesClient = Suppliers.memoize(() -> new CompaniesClient(clientOptions));
        this.contactsClient = Suppliers.memoize(() -> new ContactsClient(clientOptions));
        this.notesClient = Suppliers.memoize(() -> new NotesClient(clientOptions));
        this.tagsClient = Suppliers.memoize(() -> new TagsClient(clientOptions));
        this.conversationsClient = Suppliers.memoize(() -> new ConversationsClient(clientOptions));
        this.dataAttributesClient = Suppliers.memoize(() -> new DataAttributesClient(clientOptions));
        this.eventsClient = Suppliers.memoize(() -> new EventsClient(clientOptions));
        this.dataExportClient = Suppliers.memoize(() -> new DataExportClient(clientOptions));
        this.messagesClient = Suppliers.memoize(() -> new MessagesClient(clientOptions));
        this.segmentsClient = Suppliers.memoize(() -> new SegmentsClient(clientOptions));
        this.subscriptionTypesClient = Suppliers.memoize(() -> new SubscriptionTypesClient(clientOptions));
        this.phoneCallRedirectsClient = Suppliers.memoize(() -> new PhoneCallRedirectsClient(clientOptions));
        this.teamsClient = Suppliers.memoize(() -> new TeamsClient(clientOptions));
        this.ticketTypesClient = Suppliers.memoize(() -> new TicketTypesClient(clientOptions));
        this.ticketsClient = Suppliers.memoize(() -> new TicketsClient(clientOptions));
        this.visitorsClient = Suppliers.memoize(() -> new VisitorsClient(clientOptions));
        this.newsClient = Suppliers.memoize(() -> new NewsClient(clientOptions));
        this.unstableClient = Suppliers.memoize(() -> new UnstableClient(clientOptions));
    }

    public AdminsClient admins() {
        return this.adminsClient.get();
    }

    public ArticlesClient articles() {
        return this.articlesClient.get();
    }

    public HelpCentersClient helpCenters() {
        return this.helpCentersClient.get();
    }

    public CompaniesClient companies() {
        return this.companiesClient.get();
    }

    public ContactsClient contacts() {
        return this.contactsClient.get();
    }

    public NotesClient notes() {
        return this.notesClient.get();
    }

    public TagsClient tags() {
        return this.tagsClient.get();
    }

    public ConversationsClient conversations() {
        return this.conversationsClient.get();
    }

    public DataAttributesClient dataAttributes() {
        return this.dataAttributesClient.get();
    }

    public EventsClient events() {
        return this.eventsClient.get();
    }

    public DataExportClient dataExport() {
        return this.dataExportClient.get();
    }

    public MessagesClient messages() {
        return this.messagesClient.get();
    }

    public SegmentsClient segments() {
        return this.segmentsClient.get();
    }

    public SubscriptionTypesClient subscriptionTypes() {
        return this.subscriptionTypesClient.get();
    }

    public PhoneCallRedirectsClient phoneCallRedirects() {
        return this.phoneCallRedirectsClient.get();
    }

    public TeamsClient teams() {
        return this.teamsClient.get();
    }

    public TicketTypesClient ticketTypes() {
        return this.ticketTypesClient.get();
    }

    public TicketsClient tickets() {
        return this.ticketsClient.get();
    }

    public VisitorsClient visitors() {
        return this.visitorsClient.get();
    }

    public NewsClient news() {
        return this.newsClient.get();
    }

    public UnstableClient unstable() {
        return this.unstableClient.get();
    }

    public static IntercomBuilder builder() {
        return new IntercomBuilder();
    }
}

