/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.core;

import com.intercom.api.core.IntercomException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Response;

public class IntercomApiException
extends IntercomException {
    private final int statusCode;
    private final Object body;
    private final Map<String, List<String>> headers;

    public IntercomApiException(String message, int statusCode, Object body) {
        super(message);
        this.statusCode = statusCode;
        this.body = body;
        this.headers = new HashMap<String, List<String>>();
    }

    public IntercomApiException(String message, int statusCode, Object body, Response rawResponse) {
        super(message);
        this.statusCode = statusCode;
        this.body = body;
        this.headers = new HashMap<String, List<String>>();
        rawResponse.headers().forEach(header -> {
            String key = (String)header.component1();
            String value = (String)header.component2();
            this.headers.computeIfAbsent(key, _str -> new ArrayList()).add(value);
        });
    }

    public int statusCode() {
        return this.statusCode;
    }

    public Object body() {
        return this.body;
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    @Override
    public String toString() {
        return "IntercomApiException{message: " + this.getMessage() + ", statusCode: " + this.statusCode + ", body: " + this.body + "}";
    }
}

