/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.articles;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.core.pagination.SyncPagingIterable;
import com.intercom.api.resources.articles.RawArticlesClient;
import com.intercom.api.resources.articles.requests.CreateArticleRequest;
import com.intercom.api.resources.articles.requests.DeleteArticleRequest;
import com.intercom.api.resources.articles.requests.FindArticleRequest;
import com.intercom.api.resources.articles.requests.ListArticlesRequest;
import com.intercom.api.resources.articles.requests.SearchArticlesRequest;
import com.intercom.api.resources.articles.requests.UpdateArticleRequest;
import com.intercom.api.resources.articles.types.Article;
import com.intercom.api.resources.articles.types.ArticleListItem;
import com.intercom.api.resources.articles.types.SearchArticlesResponse;
import com.intercom.api.types.DeletedArticleObject;

public class ArticlesClient {
    protected final ClientOptions clientOptions;
    private final RawArticlesClient rawClient;

    public ArticlesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawArticlesClient(clientOptions);
    }

    public RawArticlesClient withRawResponse() {
        return this.rawClient;
    }

    public SyncPagingIterable<ArticleListItem> list() {
        return this.rawClient.list().body();
    }

    public SyncPagingIterable<ArticleListItem> list(ListArticlesRequest request) {
        return this.rawClient.list(request).body();
    }

    public SyncPagingIterable<ArticleListItem> list(ListArticlesRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).body();
    }

    public Article create(CreateArticleRequest request) {
        return this.rawClient.create(request).body();
    }

    public Article create(CreateArticleRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).body();
    }

    public Article find(FindArticleRequest request) {
        return this.rawClient.find(request).body();
    }

    public Article find(FindArticleRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).body();
    }

    public Article update(UpdateArticleRequest request) {
        return this.rawClient.update(request).body();
    }

    public Article update(UpdateArticleRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).body();
    }

    public DeletedArticleObject delete(DeleteArticleRequest request) {
        return this.rawClient.delete(request).body();
    }

    public DeletedArticleObject delete(DeleteArticleRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).body();
    }

    public SearchArticlesResponse search() {
        return this.rawClient.search().body();
    }

    public SearchArticlesResponse search(SearchArticlesRequest request) {
        return this.rawClient.search(request).body();
    }

    public SearchArticlesResponse search(SearchArticlesRequest request, RequestOptions requestOptions) {
        return this.rawClient.search(request, requestOptions).body();
    }
}

