/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.articles.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.articles.types.Article;
import com.intercom.api.resources.articles.types.ArticleSearchHighlights;
import com.intercom.api.types.CursorPages;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchArticlesResponse {
    private final int totalCount;
    private final Data data;
    private final Optional<CursorPages> pages;
    private final Map<String, Object> additionalProperties;

    private SearchArticlesResponse(int totalCount, Data data, Optional<CursorPages> pages, Map<String, Object> additionalProperties) {
        this.totalCount = totalCount;
        this.data = data;
        this.pages = pages;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "list";
    }

    @JsonProperty(value="total_count")
    public int getTotalCount() {
        return this.totalCount;
    }

    @JsonProperty(value="data")
    public Data getData() {
        return this.data;
    }

    @JsonProperty(value="pages")
    public Optional<CursorPages> getPages() {
        return this.pages;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchArticlesResponse && this.equalTo((SearchArticlesResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchArticlesResponse other) {
        return this.totalCount == other.totalCount && this.data.equals(other.data) && this.pages.equals(other.pages);
    }

    public int hashCode() {
        return Objects.hash(this.totalCount, this.data, this.pages);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TotalCountStage builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Data {
        private final Optional<List<Article>> articles;
        private final Optional<List<ArticleSearchHighlights>> highlights;
        private final Map<String, Object> additionalProperties;

        private Data(Optional<List<Article>> articles, Optional<List<ArticleSearchHighlights>> highlights, Map<String, Object> additionalProperties) {
            this.articles = articles;
            this.highlights = highlights;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="articles")
        public Optional<List<Article>> getArticles() {
            return this.articles;
        }

        @JsonProperty(value="highlights")
        public Optional<List<ArticleSearchHighlights>> getHighlights() {
            return this.highlights;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Data && this.equalTo((Data)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Data other) {
            return this.articles.equals(other.articles) && this.highlights.equals(other.highlights);
        }

        public int hashCode() {
            return Objects.hash(this.articles, this.highlights);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<List<Article>> articles = Optional.empty();
            private Optional<List<ArticleSearchHighlights>> highlights = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(Data other) {
                this.articles(other.getArticles());
                this.highlights(other.getHighlights());
                return this;
            }

            @JsonSetter(value="articles", nulls=Nulls.SKIP)
            public Builder articles(Optional<List<Article>> articles) {
                this.articles = articles;
                return this;
            }

            public Builder articles(List<Article> articles) {
                this.articles = Optional.ofNullable(articles);
                return this;
            }

            @JsonSetter(value="highlights", nulls=Nulls.SKIP)
            public Builder highlights(Optional<List<ArticleSearchHighlights>> highlights) {
                this.highlights = highlights;
                return this;
            }

            public Builder highlights(List<ArticleSearchHighlights> highlights) {
                this.highlights = Optional.ofNullable(highlights);
                return this;
            }

            public Data build() {
                return new Data(this.articles, this.highlights, this.additionalProperties);
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TotalCountStage,
    DataStage,
    _FinalStage {
        private int totalCount;
        private Data data;
        private Optional<CursorPages> pages = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SearchArticlesResponse other) {
            this.totalCount(other.getTotalCount());
            this.data(other.getData());
            this.pages(other.getPages());
            return this;
        }

        @Override
        @JsonSetter(value="total_count")
        public DataStage totalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @Override
        @JsonSetter(value="data")
        public _FinalStage data(@NotNull Data data) {
            this.data = Objects.requireNonNull(data, "data must not be null");
            return this;
        }

        @Override
        public _FinalStage pages(CursorPages pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        @Override
        @JsonSetter(value="pages", nulls=Nulls.SKIP)
        public _FinalStage pages(Optional<CursorPages> pages) {
            this.pages = pages;
            return this;
        }

        @Override
        public SearchArticlesResponse build() {
            return new SearchArticlesResponse(this.totalCount, this.data, this.pages, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SearchArticlesResponse build();

        public _FinalStage pages(Optional<CursorPages> var1);

        public _FinalStage pages(CursorPages var1);
    }

    public static interface DataStage {
        public _FinalStage data(@NotNull Data var1);
    }

    public static interface TotalCountStage {
        public DataStage totalCount(int var1);

        public Builder from(SearchArticlesResponse var1);
    }
}

