/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.contacts.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateContactRequest {
    private final String contactId;
    private final Optional<String> role;
    private final Optional<String> externalId;
    private final Optional<String> email;
    private final Optional<String> phone;
    private final Optional<String> name;
    private final Optional<String> avatar;
    private final Optional<Integer> signedUpAt;
    private final Optional<Integer> lastSeenAt;
    private final Optional<Integer> ownerId;
    private final Optional<Boolean> unsubscribedFromEmails;
    private final Optional<Map<String, Object>> customAttributes;
    private final Map<String, Object> additionalProperties;

    private UpdateContactRequest(String contactId, Optional<String> role, Optional<String> externalId, Optional<String> email, Optional<String> phone, Optional<String> name, Optional<String> avatar, Optional<Integer> signedUpAt, Optional<Integer> lastSeenAt, Optional<Integer> ownerId, Optional<Boolean> unsubscribedFromEmails, Optional<Map<String, Object>> customAttributes, Map<String, Object> additionalProperties) {
        this.contactId = contactId;
        this.role = role;
        this.externalId = externalId;
        this.email = email;
        this.phone = phone;
        this.name = name;
        this.avatar = avatar;
        this.signedUpAt = signedUpAt;
        this.lastSeenAt = lastSeenAt;
        this.ownerId = ownerId;
        this.unsubscribedFromEmails = unsubscribedFromEmails;
        this.customAttributes = customAttributes;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="contact_id")
    public String getContactId() {
        return this.contactId;
    }

    @JsonProperty(value="role")
    public Optional<String> getRole() {
        return this.role;
    }

    @JsonProperty(value="external_id")
    public Optional<String> getExternalId() {
        return this.externalId;
    }

    @JsonProperty(value="email")
    public Optional<String> getEmail() {
        return this.email;
    }

    @JsonProperty(value="phone")
    public Optional<String> getPhone() {
        return this.phone;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="avatar")
    public Optional<String> getAvatar() {
        return this.avatar;
    }

    @JsonProperty(value="signed_up_at")
    public Optional<Integer> getSignedUpAt() {
        return this.signedUpAt;
    }

    @JsonProperty(value="last_seen_at")
    public Optional<Integer> getLastSeenAt() {
        return this.lastSeenAt;
    }

    @JsonProperty(value="owner_id")
    public Optional<Integer> getOwnerId() {
        return this.ownerId;
    }

    @JsonProperty(value="unsubscribed_from_emails")
    public Optional<Boolean> getUnsubscribedFromEmails() {
        return this.unsubscribedFromEmails;
    }

    @JsonProperty(value="custom_attributes")
    public Optional<Map<String, Object>> getCustomAttributes() {
        return this.customAttributes;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateContactRequest && this.equalTo((UpdateContactRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateContactRequest other) {
        return this.contactId.equals(other.contactId) && this.role.equals(other.role) && this.externalId.equals(other.externalId) && this.email.equals(other.email) && this.phone.equals(other.phone) && this.name.equals(other.name) && this.avatar.equals(other.avatar) && this.signedUpAt.equals(other.signedUpAt) && this.lastSeenAt.equals(other.lastSeenAt) && this.ownerId.equals(other.ownerId) && this.unsubscribedFromEmails.equals(other.unsubscribedFromEmails) && this.customAttributes.equals(other.customAttributes);
    }

    public int hashCode() {
        return Objects.hash(this.contactId, this.role, this.externalId, this.email, this.phone, this.name, this.avatar, this.signedUpAt, this.lastSeenAt, this.ownerId, this.unsubscribedFromEmails, this.customAttributes);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ContactIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ContactIdStage,
    _FinalStage {
        private String contactId;
        private Optional<Map<String, Object>> customAttributes = Optional.empty();
        private Optional<Boolean> unsubscribedFromEmails = Optional.empty();
        private Optional<Integer> ownerId = Optional.empty();
        private Optional<Integer> lastSeenAt = Optional.empty();
        private Optional<Integer> signedUpAt = Optional.empty();
        private Optional<String> avatar = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> phone = Optional.empty();
        private Optional<String> email = Optional.empty();
        private Optional<String> externalId = Optional.empty();
        private Optional<String> role = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateContactRequest other) {
            this.contactId(other.getContactId());
            this.role(other.getRole());
            this.externalId(other.getExternalId());
            this.email(other.getEmail());
            this.phone(other.getPhone());
            this.name(other.getName());
            this.avatar(other.getAvatar());
            this.signedUpAt(other.getSignedUpAt());
            this.lastSeenAt(other.getLastSeenAt());
            this.ownerId(other.getOwnerId());
            this.unsubscribedFromEmails(other.getUnsubscribedFromEmails());
            this.customAttributes(other.getCustomAttributes());
            return this;
        }

        @Override
        @JsonSetter(value="contact_id")
        public _FinalStage contactId(@NotNull String contactId) {
            this.contactId = Objects.requireNonNull(contactId, "contactId must not be null");
            return this;
        }

        @Override
        public _FinalStage customAttributes(Map<String, Object> customAttributes) {
            this.customAttributes = Optional.ofNullable(customAttributes);
            return this;
        }

        @Override
        @JsonSetter(value="custom_attributes", nulls=Nulls.SKIP)
        public _FinalStage customAttributes(Optional<Map<String, Object>> customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        @Override
        public _FinalStage unsubscribedFromEmails(Boolean unsubscribedFromEmails) {
            this.unsubscribedFromEmails = Optional.ofNullable(unsubscribedFromEmails);
            return this;
        }

        @Override
        @JsonSetter(value="unsubscribed_from_emails", nulls=Nulls.SKIP)
        public _FinalStage unsubscribedFromEmails(Optional<Boolean> unsubscribedFromEmails) {
            this.unsubscribedFromEmails = unsubscribedFromEmails;
            return this;
        }

        @Override
        public _FinalStage ownerId(Integer ownerId) {
            this.ownerId = Optional.ofNullable(ownerId);
            return this;
        }

        @Override
        @JsonSetter(value="owner_id", nulls=Nulls.SKIP)
        public _FinalStage ownerId(Optional<Integer> ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        @Override
        public _FinalStage lastSeenAt(Integer lastSeenAt) {
            this.lastSeenAt = Optional.ofNullable(lastSeenAt);
            return this;
        }

        @Override
        @JsonSetter(value="last_seen_at", nulls=Nulls.SKIP)
        public _FinalStage lastSeenAt(Optional<Integer> lastSeenAt) {
            this.lastSeenAt = lastSeenAt;
            return this;
        }

        @Override
        public _FinalStage signedUpAt(Integer signedUpAt) {
            this.signedUpAt = Optional.ofNullable(signedUpAt);
            return this;
        }

        @Override
        @JsonSetter(value="signed_up_at", nulls=Nulls.SKIP)
        public _FinalStage signedUpAt(Optional<Integer> signedUpAt) {
            this.signedUpAt = signedUpAt;
            return this;
        }

        @Override
        public _FinalStage avatar(String avatar) {
            this.avatar = Optional.ofNullable(avatar);
            return this;
        }

        @Override
        @JsonSetter(value="avatar", nulls=Nulls.SKIP)
        public _FinalStage avatar(Optional<String> avatar) {
            this.avatar = avatar;
            return this;
        }

        @Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @Override
        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public _FinalStage phone(String phone) {
            this.phone = Optional.ofNullable(phone);
            return this;
        }

        @Override
        @JsonSetter(value="phone", nulls=Nulls.SKIP)
        public _FinalStage phone(Optional<String> phone) {
            this.phone = phone;
            return this;
        }

        @Override
        public _FinalStage email(String email) {
            this.email = Optional.ofNullable(email);
            return this;
        }

        @Override
        @JsonSetter(value="email", nulls=Nulls.SKIP)
        public _FinalStage email(Optional<String> email) {
            this.email = email;
            return this;
        }

        @Override
        public _FinalStage externalId(String externalId) {
            this.externalId = Optional.ofNullable(externalId);
            return this;
        }

        @Override
        @JsonSetter(value="external_id", nulls=Nulls.SKIP)
        public _FinalStage externalId(Optional<String> externalId) {
            this.externalId = externalId;
            return this;
        }

        @Override
        public _FinalStage role(String role) {
            this.role = Optional.ofNullable(role);
            return this;
        }

        @Override
        @JsonSetter(value="role", nulls=Nulls.SKIP)
        public _FinalStage role(Optional<String> role) {
            this.role = role;
            return this;
        }

        @Override
        public UpdateContactRequest build() {
            return new UpdateContactRequest(this.contactId, this.role, this.externalId, this.email, this.phone, this.name, this.avatar, this.signedUpAt, this.lastSeenAt, this.ownerId, this.unsubscribedFromEmails, this.customAttributes, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateContactRequest build();

        public _FinalStage role(Optional<String> var1);

        public _FinalStage role(String var1);

        public _FinalStage externalId(Optional<String> var1);

        public _FinalStage externalId(String var1);

        public _FinalStage email(Optional<String> var1);

        public _FinalStage email(String var1);

        public _FinalStage phone(Optional<String> var1);

        public _FinalStage phone(String var1);

        public _FinalStage name(Optional<String> var1);

        public _FinalStage name(String var1);

        public _FinalStage avatar(Optional<String> var1);

        public _FinalStage avatar(String var1);

        public _FinalStage signedUpAt(Optional<Integer> var1);

        public _FinalStage signedUpAt(Integer var1);

        public _FinalStage lastSeenAt(Optional<Integer> var1);

        public _FinalStage lastSeenAt(Integer var1);

        public _FinalStage ownerId(Optional<Integer> var1);

        public _FinalStage ownerId(Integer var1);

        public _FinalStage unsubscribedFromEmails(Optional<Boolean> var1);

        public _FinalStage unsubscribedFromEmails(Boolean var1);

        public _FinalStage customAttributes(Optional<Map<String, Object>> var1);

        public _FinalStage customAttributes(Map<String, Object> var1);
    }

    public static interface ContactIdStage {
        public _FinalStage contactId(@NotNull String var1);

        public Builder from(UpdateContactRequest var1);
    }
}

