/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.dataattributes.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.dataattributes.types.DataAttributesListRequestModel;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListDataAttributesRequest {
    private final Optional<DataAttributesListRequestModel> model;
    private final Optional<Boolean> includeArchived;
    private final Map<String, Object> additionalProperties;

    private ListDataAttributesRequest(Optional<DataAttributesListRequestModel> model, Optional<Boolean> includeArchived, Map<String, Object> additionalProperties) {
        this.model = model;
        this.includeArchived = includeArchived;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="model")
    public Optional<DataAttributesListRequestModel> getModel() {
        return this.model;
    }

    @JsonProperty(value="include_archived")
    public Optional<Boolean> getIncludeArchived() {
        return this.includeArchived;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListDataAttributesRequest && this.equalTo((ListDataAttributesRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListDataAttributesRequest other) {
        return this.model.equals(other.model) && this.includeArchived.equals(other.includeArchived);
    }

    public int hashCode() {
        return Objects.hash(this.model, this.includeArchived);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<DataAttributesListRequestModel> model = Optional.empty();
        private Optional<Boolean> includeArchived = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListDataAttributesRequest other) {
            this.model(other.getModel());
            this.includeArchived(other.getIncludeArchived());
            return this;
        }

        @JsonSetter(value="model", nulls=Nulls.SKIP)
        public Builder model(Optional<DataAttributesListRequestModel> model) {
            this.model = model;
            return this;
        }

        public Builder model(DataAttributesListRequestModel model) {
            this.model = Optional.ofNullable(model);
            return this;
        }

        @JsonSetter(value="include_archived", nulls=Nulls.SKIP)
        public Builder includeArchived(Optional<Boolean> includeArchived) {
            this.includeArchived = includeArchived;
            return this;
        }

        public Builder includeArchived(Boolean includeArchived) {
            this.includeArchived = Optional.ofNullable(includeArchived);
            return this;
        }

        public ListDataAttributesRequest build() {
            return new ListDataAttributesRequest(this.model, this.includeArchived, this.additionalProperties);
        }
    }
}

