/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.phonecallredirects.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreatePhoneCallRedirectRequest {
    private final String phone;
    private final Optional<Map<String, Object>> customAttributes;
    private final Map<String, Object> additionalProperties;

    private CreatePhoneCallRedirectRequest(String phone, Optional<Map<String, Object>> customAttributes, Map<String, Object> additionalProperties) {
        this.phone = phone;
        this.customAttributes = customAttributes;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="phone")
    public String getPhone() {
        return this.phone;
    }

    @JsonProperty(value="custom_attributes")
    public Optional<Map<String, Object>> getCustomAttributes() {
        return this.customAttributes;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreatePhoneCallRedirectRequest && this.equalTo((CreatePhoneCallRedirectRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreatePhoneCallRedirectRequest other) {
        return this.phone.equals(other.phone) && this.customAttributes.equals(other.customAttributes);
    }

    public int hashCode() {
        return Objects.hash(this.phone, this.customAttributes);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PhoneStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PhoneStage,
    _FinalStage {
        private String phone;
        private Optional<Map<String, Object>> customAttributes = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreatePhoneCallRedirectRequest other) {
            this.phone(other.getPhone());
            this.customAttributes(other.getCustomAttributes());
            return this;
        }

        @Override
        @JsonSetter(value="phone")
        public _FinalStage phone(@NotNull String phone) {
            this.phone = Objects.requireNonNull(phone, "phone must not be null");
            return this;
        }

        @Override
        public _FinalStage customAttributes(Map<String, Object> customAttributes) {
            this.customAttributes = Optional.ofNullable(customAttributes);
            return this;
        }

        @Override
        @JsonSetter(value="custom_attributes", nulls=Nulls.SKIP)
        public _FinalStage customAttributes(Optional<Map<String, Object>> customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        @Override
        public CreatePhoneCallRedirectRequest build() {
            return new CreatePhoneCallRedirectRequest(this.phone, this.customAttributes, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreatePhoneCallRedirectRequest build();

        public _FinalStage customAttributes(Optional<Map<String, Object>> var1);

        public _FinalStage customAttributes(Map<String, Object> var1);
    }

    public static interface PhoneStage {
        public _FinalStage phone(@NotNull String var1);

        public Builder from(CreatePhoneCallRedirectRequest var1);
    }
}

