/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.tags.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UntagConversationRequest {
    private final String conversationId;
    private final String tagId;
    private final String adminId;
    private final Map<String, Object> additionalProperties;

    private UntagConversationRequest(String conversationId, String tagId, String adminId, Map<String, Object> additionalProperties) {
        this.conversationId = conversationId;
        this.tagId = tagId;
        this.adminId = adminId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="conversation_id")
    public String getConversationId() {
        return this.conversationId;
    }

    @JsonProperty(value="tag_id")
    public String getTagId() {
        return this.tagId;
    }

    @JsonProperty(value="admin_id")
    public String getAdminId() {
        return this.adminId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UntagConversationRequest && this.equalTo((UntagConversationRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UntagConversationRequest other) {
        return this.conversationId.equals(other.conversationId) && this.tagId.equals(other.tagId) && this.adminId.equals(other.adminId);
    }

    public int hashCode() {
        return Objects.hash(this.conversationId, this.tagId, this.adminId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ConversationIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ConversationIdStage,
    TagIdStage,
    AdminIdStage,
    _FinalStage {
        private String conversationId;
        private String tagId;
        private String adminId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UntagConversationRequest other) {
            this.conversationId(other.getConversationId());
            this.tagId(other.getTagId());
            this.adminId(other.getAdminId());
            return this;
        }

        @Override
        @JsonSetter(value="conversation_id")
        public TagIdStage conversationId(@NotNull String conversationId) {
            this.conversationId = Objects.requireNonNull(conversationId, "conversationId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="tag_id")
        public AdminIdStage tagId(@NotNull String tagId) {
            this.tagId = Objects.requireNonNull(tagId, "tagId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="admin_id")
        public _FinalStage adminId(@NotNull String adminId) {
            this.adminId = Objects.requireNonNull(adminId, "adminId must not be null");
            return this;
        }

        @Override
        public UntagConversationRequest build() {
            return new UntagConversationRequest(this.conversationId, this.tagId, this.adminId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UntagConversationRequest build();
    }

    public static interface AdminIdStage {
        public _FinalStage adminId(@NotNull String var1);
    }

    public static interface TagIdStage {
        public AdminIdStage tagId(@NotNull String var1);
    }

    public static interface ConversationIdStage {
        public TagIdStage conversationId(@NotNull String var1);

        public Builder from(UntagConversationRequest var1);
    }
}

