/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.contacts;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.contacts.RawContactsClient;
import com.intercom.api.resources.unstable.contacts.requests.ArchiveContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.BlockContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.DeleteContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.ListCompaniesForAContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.ListSegmentsForAContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.ListSubscriptionsForAContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.ListTagsForAContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.MergeContactsRequest;
import com.intercom.api.resources.unstable.contacts.requests.ShowContactByExternalIdRequest;
import com.intercom.api.resources.unstable.contacts.requests.ShowContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.UnarchiveContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.UpdateContactRequest;
import com.intercom.api.resources.unstable.contacts.types.CreateContactResponse;
import com.intercom.api.resources.unstable.contacts.types.MergeContactResponse;
import com.intercom.api.resources.unstable.contacts.types.ShowContactByExternalIdResponse;
import com.intercom.api.resources.unstable.contacts.types.ShowContactResponse;
import com.intercom.api.resources.unstable.contacts.types.UpdateContactResponse;
import com.intercom.api.resources.unstable.types.ContactArchived;
import com.intercom.api.resources.unstable.types.ContactAttachedCompanies;
import com.intercom.api.resources.unstable.types.ContactBlocked;
import com.intercom.api.resources.unstable.types.ContactDeleted;
import com.intercom.api.resources.unstable.types.ContactList;
import com.intercom.api.resources.unstable.types.ContactSegments;
import com.intercom.api.resources.unstable.types.ContactUnarchived;
import com.intercom.api.resources.unstable.types.SearchRequest;
import com.intercom.api.resources.unstable.types.SubscriptionTypeList;
import com.intercom.api.resources.unstable.types.TagList;

public class ContactsClient {
    protected final ClientOptions clientOptions;
    private final RawContactsClient rawClient;

    public ContactsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawContactsClient(clientOptions);
    }

    public RawContactsClient withRawResponse() {
        return this.rawClient;
    }

    public ContactAttachedCompanies listCompaniesForAContact(ListCompaniesForAContactRequest request) {
        return this.rawClient.listCompaniesForAContact(request).body();
    }

    public ContactAttachedCompanies listCompaniesForAContact(ListCompaniesForAContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCompaniesForAContact(request, requestOptions).body();
    }

    public ContactSegments listSegmentsForAContact(ListSegmentsForAContactRequest request) {
        return this.rawClient.listSegmentsForAContact(request).body();
    }

    public ContactSegments listSegmentsForAContact(ListSegmentsForAContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.listSegmentsForAContact(request, requestOptions).body();
    }

    public SubscriptionTypeList listSubscriptionsForAContact(ListSubscriptionsForAContactRequest request) {
        return this.rawClient.listSubscriptionsForAContact(request).body();
    }

    public SubscriptionTypeList listSubscriptionsForAContact(ListSubscriptionsForAContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.listSubscriptionsForAContact(request, requestOptions).body();
    }

    public TagList listTagsForAContact(ListTagsForAContactRequest request) {
        return this.rawClient.listTagsForAContact(request).body();
    }

    public TagList listTagsForAContact(ListTagsForAContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.listTagsForAContact(request, requestOptions).body();
    }

    public ShowContactResponse showContact(ShowContactRequest request) {
        return this.rawClient.showContact(request).body();
    }

    public ShowContactResponse showContact(ShowContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.showContact(request, requestOptions).body();
    }

    public UpdateContactResponse updateContact(UpdateContactRequest request) {
        return this.rawClient.updateContact(request).body();
    }

    public UpdateContactResponse updateContact(UpdateContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateContact(request, requestOptions).body();
    }

    public ContactDeleted deleteContact(DeleteContactRequest request) {
        return this.rawClient.deleteContact(request).body();
    }

    public ContactDeleted deleteContact(DeleteContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteContact(request, requestOptions).body();
    }

    public MergeContactResponse mergeContact() {
        return this.rawClient.mergeContact().body();
    }

    public MergeContactResponse mergeContact(MergeContactsRequest request) {
        return this.rawClient.mergeContact(request).body();
    }

    public MergeContactResponse mergeContact(MergeContactsRequest request, RequestOptions requestOptions) {
        return this.rawClient.mergeContact(request, requestOptions).body();
    }

    public ContactList searchContacts(SearchRequest request) {
        return this.rawClient.searchContacts(request).body();
    }

    public ContactList searchContacts(SearchRequest request, RequestOptions requestOptions) {
        return this.rawClient.searchContacts(request, requestOptions).body();
    }

    public ContactList listContacts() {
        return this.rawClient.listContacts().body();
    }

    public ContactList listContacts(RequestOptions requestOptions) {
        return this.rawClient.listContacts(requestOptions).body();
    }

    public CreateContactResponse createContact(Object request) {
        return this.rawClient.createContact(request).body();
    }

    public CreateContactResponse createContact(Object request, RequestOptions requestOptions) {
        return this.rawClient.createContact(request, requestOptions).body();
    }

    public ShowContactByExternalIdResponse showContactByExternalId(ShowContactByExternalIdRequest request) {
        return this.rawClient.showContactByExternalId(request).body();
    }

    public ShowContactByExternalIdResponse showContactByExternalId(ShowContactByExternalIdRequest request, RequestOptions requestOptions) {
        return this.rawClient.showContactByExternalId(request, requestOptions).body();
    }

    public ContactArchived archiveContact(ArchiveContactRequest request) {
        return this.rawClient.archiveContact(request).body();
    }

    public ContactArchived archiveContact(ArchiveContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.archiveContact(request, requestOptions).body();
    }

    public ContactUnarchived unarchiveContact(UnarchiveContactRequest request) {
        return this.rawClient.unarchiveContact(request).body();
    }

    public ContactUnarchived unarchiveContact(UnarchiveContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.unarchiveContact(request, requestOptions).body();
    }

    public ContactBlocked blockContact(BlockContactRequest request) {
        return this.rawClient.blockContact(request).body();
    }

    public ContactBlocked blockContact(BlockContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.blockContact(request, requestOptions).body();
    }
}

