/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.news;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.IntercomApiException;
import com.intercom.api.core.IntercomException;
import com.intercom.api.core.IntercomHttpResponse;
import com.intercom.api.core.MediaTypes;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.errors.NotFoundError;
import com.intercom.api.resources.unstable.errors.UnauthorizedError;
import com.intercom.api.resources.unstable.news.requests.DeleteNewsItemRequest;
import com.intercom.api.resources.unstable.news.requests.ListLiveNewsfeedItemsRequest;
import com.intercom.api.resources.unstable.news.requests.RetrieveNewsItemRequest;
import com.intercom.api.resources.unstable.news.requests.RetrieveNewsfeedRequest;
import com.intercom.api.resources.unstable.news.requests.UpdateNewsItemRequest;
import com.intercom.api.resources.unstable.news.types.NewsItem;
import com.intercom.api.resources.unstable.news.types.Newsfeed;
import com.intercom.api.resources.unstable.types.DeletedObject;
import com.intercom.api.resources.unstable.types.Error;
import com.intercom.api.resources.unstable.types.NewsItemRequest;
import com.intercom.api.resources.unstable.types.PaginatedResponse;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawNewsClient {
    protected final ClientOptions clientOptions;

    public RawNewsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public IntercomHttpResponse<PaginatedResponse> listNewsItems() {
        return this.listNewsItems(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IntercomHttpResponse<PaginatedResponse> listNewsItems(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("news/news_items").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                IntercomHttpResponse<PaginatedResponse> intercomHttpResponse = new IntercomHttpResponse<PaginatedResponse>((PaginatedResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), PaginatedResponse.class), response);
                return intercomHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                if (response.code() != 401) throw new IntercomApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new IntercomApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    public IntercomHttpResponse<NewsItem> createNewsItem(NewsItemRequest request) {
        return this.createNewsItem(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IntercomHttpResponse<NewsItem> createNewsItem(NewsItemRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("news/news_items").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                IntercomHttpResponse<NewsItem> intercomHttpResponse = new IntercomHttpResponse<NewsItem>((NewsItem)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), NewsItem.class), response);
                return intercomHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                if (response.code() != 401) throw new IntercomApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new IntercomApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    public IntercomHttpResponse<NewsItem> retrieveNewsItem(RetrieveNewsItemRequest request) {
        return this.retrieveNewsItem(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IntercomHttpResponse<NewsItem> retrieveNewsItem(RetrieveNewsItemRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("news/news_items").addPathSegment(Integer.toString(request.getId())).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                IntercomHttpResponse<NewsItem> intercomHttpResponse = new IntercomHttpResponse<NewsItem>((NewsItem)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), NewsItem.class), response);
                return intercomHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401: {
                        throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    }
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                }
                throw new IntercomApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new IntercomApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    public IntercomHttpResponse<NewsItem> updateNewsItem(UpdateNewsItemRequest request) {
        return this.updateNewsItem(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IntercomHttpResponse<NewsItem> updateNewsItem(UpdateNewsItemRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("news/news_items").addPathSegment(Integer.toString(request.getId())).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request.getBody()), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("PUT", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                IntercomHttpResponse<NewsItem> intercomHttpResponse = new IntercomHttpResponse<NewsItem>((NewsItem)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), NewsItem.class), response);
                return intercomHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401: {
                        throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    }
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                }
                throw new IntercomApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new IntercomApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    public IntercomHttpResponse<DeletedObject> deleteNewsItem(DeleteNewsItemRequest request) {
        return this.deleteNewsItem(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IntercomHttpResponse<DeletedObject> deleteNewsItem(DeleteNewsItemRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("news/news_items").addPathSegment(Integer.toString(request.getId())).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("DELETE", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                IntercomHttpResponse<DeletedObject> intercomHttpResponse = new IntercomHttpResponse<DeletedObject>((DeletedObject)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), DeletedObject.class), response);
                return intercomHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401: {
                        throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    }
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                }
                throw new IntercomApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new IntercomApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    public IntercomHttpResponse<PaginatedResponse> listLiveNewsfeedItems(ListLiveNewsfeedItemsRequest request) {
        return this.listLiveNewsfeedItems(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IntercomHttpResponse<PaginatedResponse> listLiveNewsfeedItems(ListLiveNewsfeedItemsRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("news/newsfeeds").addPathSegment(request.getId()).addPathSegments("items").build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                IntercomHttpResponse<PaginatedResponse> intercomHttpResponse = new IntercomHttpResponse<PaginatedResponse>((PaginatedResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), PaginatedResponse.class), response);
                return intercomHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                if (response.code() != 401) throw new IntercomApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new IntercomApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    public IntercomHttpResponse<PaginatedResponse> listNewsfeeds() {
        return this.listNewsfeeds(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IntercomHttpResponse<PaginatedResponse> listNewsfeeds(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("news/newsfeeds").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                IntercomHttpResponse<PaginatedResponse> intercomHttpResponse = new IntercomHttpResponse<PaginatedResponse>((PaginatedResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), PaginatedResponse.class), response);
                return intercomHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                if (response.code() != 401) throw new IntercomApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new IntercomApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    public IntercomHttpResponse<Newsfeed> retrieveNewsfeed(RetrieveNewsfeedRequest request) {
        return this.retrieveNewsfeed(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IntercomHttpResponse<Newsfeed> retrieveNewsfeed(RetrieveNewsfeedRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("news/newsfeeds").addPathSegment(request.getId()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                IntercomHttpResponse<Newsfeed> intercomHttpResponse = new IntercomHttpResponse<Newsfeed>((Newsfeed)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), Newsfeed.class), response);
                return intercomHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                if (response.code() != 401) throw new IntercomApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            throw new IntercomApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }
}

