/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.subscriptiontypes;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.subscriptiontypes.AsyncRawSubscriptionTypesClient;
import com.intercom.api.resources.unstable.subscriptiontypes.requests.AttachSubscriptionTypeToContactRequest;
import com.intercom.api.resources.unstable.subscriptiontypes.requests.DetachSubscriptionTypeToContactRequest;
import com.intercom.api.resources.unstable.subscriptiontypes.types.SubscriptionType;
import com.intercom.api.resources.unstable.types.SubscriptionTypeList;
import java.util.concurrent.CompletableFuture;

public class AsyncSubscriptionTypesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawSubscriptionTypesClient rawClient;

    public AsyncSubscriptionTypesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawSubscriptionTypesClient(clientOptions);
    }

    public AsyncRawSubscriptionTypesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SubscriptionType> attachSubscriptionTypeToContact(AttachSubscriptionTypeToContactRequest request) {
        return this.rawClient.attachSubscriptionTypeToContact(request).thenApply(response -> (SubscriptionType)response.body());
    }

    public CompletableFuture<SubscriptionType> attachSubscriptionTypeToContact(AttachSubscriptionTypeToContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.attachSubscriptionTypeToContact(request, requestOptions).thenApply(response -> (SubscriptionType)response.body());
    }

    public CompletableFuture<SubscriptionType> detachSubscriptionTypeToContact(DetachSubscriptionTypeToContactRequest request) {
        return this.rawClient.detachSubscriptionTypeToContact(request).thenApply(response -> (SubscriptionType)response.body());
    }

    public CompletableFuture<SubscriptionType> detachSubscriptionTypeToContact(DetachSubscriptionTypeToContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.detachSubscriptionTypeToContact(request, requestOptions).thenApply(response -> (SubscriptionType)response.body());
    }

    public CompletableFuture<SubscriptionTypeList> listSubscriptionTypes() {
        return this.rawClient.listSubscriptionTypes().thenApply(response -> (SubscriptionTypeList)response.body());
    }

    public CompletableFuture<SubscriptionTypeList> listSubscriptionTypes(RequestOptions requestOptions) {
        return this.rawClient.listSubscriptionTypes(requestOptions).thenApply(response -> (SubscriptionTypeList)response.body());
    }
}

