/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.tags.types;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.CreateOrUpdateTagRequest;
import com.intercom.api.resources.unstable.types.TagCompanyRequest;
import com.intercom.api.resources.unstable.types.TagMultipleUsersRequest;
import com.intercom.api.resources.unstable.types.UntagCompanyRequest;
import java.io.IOException;
import java.util.Objects;

@JsonDeserialize(using=Deserializer.class)
public final class CreateTagRequestBody {
    private final Object value;
    private final int type;

    private CreateTagRequestBody(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((CreateOrUpdateTagRequest)this.value);
        }
        if (this.type == 1) {
            return visitor.visit((TagCompanyRequest)this.value);
        }
        if (this.type == 2) {
            return visitor.visit((UntagCompanyRequest)this.value);
        }
        if (this.type == 3) {
            return visitor.visit((TagMultipleUsersRequest)this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateTagRequestBody && this.equalTo((CreateTagRequestBody)other);
    }

    private boolean equalTo(CreateTagRequestBody other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public static CreateTagRequestBody of(CreateOrUpdateTagRequest value) {
        return new CreateTagRequestBody(value, 0);
    }

    public static CreateTagRequestBody of(TagCompanyRequest value) {
        return new CreateTagRequestBody(value, 1);
    }

    public static CreateTagRequestBody of(UntagCompanyRequest value) {
        return new CreateTagRequestBody(value, 2);
    }

    public static CreateTagRequestBody of(TagMultipleUsersRequest value) {
        return new CreateTagRequestBody(value, 3);
    }

    static final class Deserializer
    extends StdDeserializer<CreateTagRequestBody> {
        Deserializer() {
            super(CreateTagRequestBody.class);
        }

        public CreateTagRequestBody deserialize(JsonParser p, DeserializationContext context) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return CreateTagRequestBody.of((CreateOrUpdateTagRequest)ObjectMappers.JSON_MAPPER.convertValue(value, CreateOrUpdateTagRequest.class));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return CreateTagRequestBody.of((TagCompanyRequest)ObjectMappers.JSON_MAPPER.convertValue(value, TagCompanyRequest.class));
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    try {
                        return CreateTagRequestBody.of((UntagCompanyRequest)ObjectMappers.JSON_MAPPER.convertValue(value, UntagCompanyRequest.class));
                    }
                    catch (IllegalArgumentException illegalArgumentException3) {
                        try {
                            return CreateTagRequestBody.of((TagMultipleUsersRequest)ObjectMappers.JSON_MAPPER.convertValue(value, TagMultipleUsersRequest.class));
                        }
                        catch (IllegalArgumentException illegalArgumentException4) {
                            throw new JsonParseException(p, "Failed to deserialize");
                        }
                    }
                }
            }
        }
    }

    public static interface Visitor<T> {
        public T visit(CreateOrUpdateTagRequest var1);

        public T visit(TagCompanyRequest var1);

        public T visit(UntagCompanyRequest var1);

        public T visit(TagMultipleUsersRequest var1);
    }
}

