/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.teams;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.teams.AsyncRawTeamsClient;
import com.intercom.api.resources.unstable.teams.requests.RetrieveTeamRequest;
import com.intercom.api.resources.unstable.teams.types.Team;
import com.intercom.api.resources.unstable.types.TeamList;
import java.util.concurrent.CompletableFuture;

public class AsyncTeamsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawTeamsClient rawClient;

    public AsyncTeamsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTeamsClient(clientOptions);
    }

    public AsyncRawTeamsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<TeamList> listTeams() {
        return this.rawClient.listTeams().thenApply(response -> (TeamList)response.body());
    }

    public CompletableFuture<TeamList> listTeams(RequestOptions requestOptions) {
        return this.rawClient.listTeams(requestOptions).thenApply(response -> (TeamList)response.body());
    }

    public CompletableFuture<Team> retrieveTeam(RetrieveTeamRequest request) {
        return this.rawClient.retrieveTeam(request).thenApply(response -> (Team)response.body());
    }

    public CompletableFuture<Team> retrieveTeam(RetrieveTeamRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveTeam(request, requestOptions).thenApply(response -> (Team)response.body());
    }
}

