/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.ConversationAttachmentFiles;
import com.intercom.api.resources.unstable.types.QuickReplyOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class AdminReplyConversationRequest {
    private final MessageType messageType;
    private final Optional<String> body;
    private final String adminId;
    private final Optional<Integer> createdAt;
    private final Optional<List<QuickReplyOption>> replyOptions;
    private final Optional<List<String>> attachmentUrls;
    private final Optional<List<ConversationAttachmentFiles>> attachmentFiles;
    private final Map<String, Object> additionalProperties;

    private AdminReplyConversationRequest(MessageType messageType, Optional<String> body, String adminId, Optional<Integer> createdAt, Optional<List<QuickReplyOption>> replyOptions, Optional<List<String>> attachmentUrls, Optional<List<ConversationAttachmentFiles>> attachmentFiles, Map<String, Object> additionalProperties) {
        this.messageType = messageType;
        this.body = body;
        this.adminId = adminId;
        this.createdAt = createdAt;
        this.replyOptions = replyOptions;
        this.attachmentUrls = attachmentUrls;
        this.attachmentFiles = attachmentFiles;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="message_type")
    public MessageType getMessageType() {
        return this.messageType;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "admin";
    }

    @JsonProperty(value="body")
    public Optional<String> getBody() {
        return this.body;
    }

    @JsonProperty(value="admin_id")
    public String getAdminId() {
        return this.adminId;
    }

    @JsonProperty(value="created_at")
    public Optional<Integer> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="reply_options")
    public Optional<List<QuickReplyOption>> getReplyOptions() {
        return this.replyOptions;
    }

    @JsonProperty(value="attachment_urls")
    public Optional<List<String>> getAttachmentUrls() {
        return this.attachmentUrls;
    }

    @JsonProperty(value="attachment_files")
    public Optional<List<ConversationAttachmentFiles>> getAttachmentFiles() {
        return this.attachmentFiles;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AdminReplyConversationRequest && this.equalTo((AdminReplyConversationRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AdminReplyConversationRequest other) {
        return this.messageType.equals(other.messageType) && this.body.equals(other.body) && this.adminId.equals(other.adminId) && this.createdAt.equals(other.createdAt) && this.replyOptions.equals(other.replyOptions) && this.attachmentUrls.equals(other.attachmentUrls) && this.attachmentFiles.equals(other.attachmentFiles);
    }

    public int hashCode() {
        return Objects.hash(this.messageType, this.body, this.adminId, this.createdAt, this.replyOptions, this.attachmentUrls, this.attachmentFiles);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static MessageTypeStage builder() {
        return new Builder();
    }

    public static final class MessageType {
        public static final MessageType NOTE = new MessageType(Value.NOTE, "note");
        public static final MessageType QUICK_REPLY = new MessageType(Value.QUICK_REPLY, "quick_reply");
        public static final MessageType COMMENT = new MessageType(Value.COMMENT, "comment");
        private final Value value;
        private final String string;

        MessageType(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof MessageType && this.string.equals(((MessageType)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case NOTE: {
                    return visitor.visitNote();
                }
                case QUICK_REPLY: {
                    return visitor.visitQuickReply();
                }
                case COMMENT: {
                    return visitor.visitComment();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static MessageType valueOf(String value) {
            switch (value) {
                case "note": {
                    return NOTE;
                }
                case "quick_reply": {
                    return QUICK_REPLY;
                }
                case "comment": {
                    return COMMENT;
                }
            }
            return new MessageType(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitComment();

            public T visitNote();

            public T visitQuickReply();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            COMMENT,
            NOTE,
            QUICK_REPLY,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements MessageTypeStage,
    AdminIdStage,
    _FinalStage {
        private MessageType messageType;
        private String adminId;
        private Optional<List<ConversationAttachmentFiles>> attachmentFiles = Optional.empty();
        private Optional<List<String>> attachmentUrls = Optional.empty();
        private Optional<List<QuickReplyOption>> replyOptions = Optional.empty();
        private Optional<Integer> createdAt = Optional.empty();
        private Optional<String> body = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(AdminReplyConversationRequest other) {
            this.messageType(other.getMessageType());
            this.body(other.getBody());
            this.adminId(other.getAdminId());
            this.createdAt(other.getCreatedAt());
            this.replyOptions(other.getReplyOptions());
            this.attachmentUrls(other.getAttachmentUrls());
            this.attachmentFiles(other.getAttachmentFiles());
            return this;
        }

        @Override
        @JsonSetter(value="message_type")
        public AdminIdStage messageType(@NotNull MessageType messageType) {
            this.messageType = Objects.requireNonNull(messageType, "messageType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="admin_id")
        public _FinalStage adminId(@NotNull String adminId) {
            this.adminId = Objects.requireNonNull(adminId, "adminId must not be null");
            return this;
        }

        @Override
        public _FinalStage attachmentFiles(List<ConversationAttachmentFiles> attachmentFiles) {
            this.attachmentFiles = Optional.ofNullable(attachmentFiles);
            return this;
        }

        @Override
        @JsonSetter(value="attachment_files", nulls=Nulls.SKIP)
        public _FinalStage attachmentFiles(Optional<List<ConversationAttachmentFiles>> attachmentFiles) {
            this.attachmentFiles = attachmentFiles;
            return this;
        }

        @Override
        public _FinalStage attachmentUrls(List<String> attachmentUrls) {
            this.attachmentUrls = Optional.ofNullable(attachmentUrls);
            return this;
        }

        @Override
        @JsonSetter(value="attachment_urls", nulls=Nulls.SKIP)
        public _FinalStage attachmentUrls(Optional<List<String>> attachmentUrls) {
            this.attachmentUrls = attachmentUrls;
            return this;
        }

        @Override
        public _FinalStage replyOptions(List<QuickReplyOption> replyOptions) {
            this.replyOptions = Optional.ofNullable(replyOptions);
            return this;
        }

        @Override
        @JsonSetter(value="reply_options", nulls=Nulls.SKIP)
        public _FinalStage replyOptions(Optional<List<QuickReplyOption>> replyOptions) {
            this.replyOptions = replyOptions;
            return this;
        }

        @Override
        public _FinalStage createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @Override
        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public _FinalStage createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        @Override
        @JsonSetter(value="body", nulls=Nulls.SKIP)
        public _FinalStage body(Optional<String> body) {
            this.body = body;
            return this;
        }

        @Override
        public AdminReplyConversationRequest build() {
            return new AdminReplyConversationRequest(this.messageType, this.body, this.adminId, this.createdAt, this.replyOptions, this.attachmentUrls, this.attachmentFiles, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public AdminReplyConversationRequest build();

        public _FinalStage body(Optional<String> var1);

        public _FinalStage body(String var1);

        public _FinalStage createdAt(Optional<Integer> var1);

        public _FinalStage createdAt(Integer var1);

        public _FinalStage replyOptions(Optional<List<QuickReplyOption>> var1);

        public _FinalStage replyOptions(List<QuickReplyOption> var1);

        public _FinalStage attachmentUrls(Optional<List<String>> var1);

        public _FinalStage attachmentUrls(List<String> var1);

        public _FinalStage attachmentFiles(Optional<List<ConversationAttachmentFiles>> var1);

        public _FinalStage attachmentFiles(List<ConversationAttachmentFiles> var1);
    }

    public static interface AdminIdStage {
        public _FinalStage adminId(@NotNull String var1);
    }

    public static interface MessageTypeStage {
        public AdminIdStage messageType(@NotNull MessageType var1);

        public Builder from(AdminReplyConversationRequest var1);
    }
}

