/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.ConversationResponseTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ConversationStatistics {
    private final Optional<String> type;
    private final Optional<Integer> timeToAssignment;
    private final Optional<Integer> timeToAdminReply;
    private final Optional<Integer> timeToFirstClose;
    private final Optional<Integer> timeToLastClose;
    private final Optional<Integer> medianTimeToReply;
    private final Optional<Integer> firstContactReplyAt;
    private final Optional<Integer> firstAssignmentAt;
    private final Optional<Integer> firstAdminReplyAt;
    private final Optional<Integer> firstCloseAt;
    private final Optional<Integer> lastAssignmentAt;
    private final Optional<Integer> lastAssignmentAdminReplyAt;
    private final Optional<Integer> lastContactReplyAt;
    private final Optional<Integer> lastAdminReplyAt;
    private final Optional<Integer> lastCloseAt;
    private final Optional<String> lastClosedById;
    private final Optional<Integer> countReopens;
    private final Optional<Integer> countAssignments;
    private final Optional<Integer> countConversationParts;
    private final Optional<List<ConversationResponseTime>> assignedTeamFirstResponseTimeByTeam;
    private final Optional<List<ConversationResponseTime>> assignedTeamFirstResponseTimeInOfficeHours;
    private final Optional<Integer> handlingTime;
    private final Map<String, Object> additionalProperties;

    private ConversationStatistics(Optional<String> type, Optional<Integer> timeToAssignment, Optional<Integer> timeToAdminReply, Optional<Integer> timeToFirstClose, Optional<Integer> timeToLastClose, Optional<Integer> medianTimeToReply, Optional<Integer> firstContactReplyAt, Optional<Integer> firstAssignmentAt, Optional<Integer> firstAdminReplyAt, Optional<Integer> firstCloseAt, Optional<Integer> lastAssignmentAt, Optional<Integer> lastAssignmentAdminReplyAt, Optional<Integer> lastContactReplyAt, Optional<Integer> lastAdminReplyAt, Optional<Integer> lastCloseAt, Optional<String> lastClosedById, Optional<Integer> countReopens, Optional<Integer> countAssignments, Optional<Integer> countConversationParts, Optional<List<ConversationResponseTime>> assignedTeamFirstResponseTimeByTeam, Optional<List<ConversationResponseTime>> assignedTeamFirstResponseTimeInOfficeHours, Optional<Integer> handlingTime, Map<String, Object> additionalProperties) {
        this.type = type;
        this.timeToAssignment = timeToAssignment;
        this.timeToAdminReply = timeToAdminReply;
        this.timeToFirstClose = timeToFirstClose;
        this.timeToLastClose = timeToLastClose;
        this.medianTimeToReply = medianTimeToReply;
        this.firstContactReplyAt = firstContactReplyAt;
        this.firstAssignmentAt = firstAssignmentAt;
        this.firstAdminReplyAt = firstAdminReplyAt;
        this.firstCloseAt = firstCloseAt;
        this.lastAssignmentAt = lastAssignmentAt;
        this.lastAssignmentAdminReplyAt = lastAssignmentAdminReplyAt;
        this.lastContactReplyAt = lastContactReplyAt;
        this.lastAdminReplyAt = lastAdminReplyAt;
        this.lastCloseAt = lastCloseAt;
        this.lastClosedById = lastClosedById;
        this.countReopens = countReopens;
        this.countAssignments = countAssignments;
        this.countConversationParts = countConversationParts;
        this.assignedTeamFirstResponseTimeByTeam = assignedTeamFirstResponseTimeByTeam;
        this.assignedTeamFirstResponseTimeInOfficeHours = assignedTeamFirstResponseTimeInOfficeHours;
        this.handlingTime = handlingTime;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="time_to_assignment")
    public Optional<Integer> getTimeToAssignment() {
        return this.timeToAssignment;
    }

    @JsonProperty(value="time_to_admin_reply")
    public Optional<Integer> getTimeToAdminReply() {
        return this.timeToAdminReply;
    }

    @JsonProperty(value="time_to_first_close")
    public Optional<Integer> getTimeToFirstClose() {
        return this.timeToFirstClose;
    }

    @JsonProperty(value="time_to_last_close")
    public Optional<Integer> getTimeToLastClose() {
        return this.timeToLastClose;
    }

    @JsonProperty(value="median_time_to_reply")
    public Optional<Integer> getMedianTimeToReply() {
        return this.medianTimeToReply;
    }

    @JsonProperty(value="first_contact_reply_at")
    public Optional<Integer> getFirstContactReplyAt() {
        return this.firstContactReplyAt;
    }

    @JsonProperty(value="first_assignment_at")
    public Optional<Integer> getFirstAssignmentAt() {
        return this.firstAssignmentAt;
    }

    @JsonProperty(value="first_admin_reply_at")
    public Optional<Integer> getFirstAdminReplyAt() {
        return this.firstAdminReplyAt;
    }

    @JsonProperty(value="first_close_at")
    public Optional<Integer> getFirstCloseAt() {
        return this.firstCloseAt;
    }

    @JsonProperty(value="last_assignment_at")
    public Optional<Integer> getLastAssignmentAt() {
        return this.lastAssignmentAt;
    }

    @JsonProperty(value="last_assignment_admin_reply_at")
    public Optional<Integer> getLastAssignmentAdminReplyAt() {
        return this.lastAssignmentAdminReplyAt;
    }

    @JsonProperty(value="last_contact_reply_at")
    public Optional<Integer> getLastContactReplyAt() {
        return this.lastContactReplyAt;
    }

    @JsonProperty(value="last_admin_reply_at")
    public Optional<Integer> getLastAdminReplyAt() {
        return this.lastAdminReplyAt;
    }

    @JsonProperty(value="last_close_at")
    public Optional<Integer> getLastCloseAt() {
        return this.lastCloseAt;
    }

    @JsonProperty(value="last_closed_by_id")
    public Optional<String> getLastClosedById() {
        return this.lastClosedById;
    }

    @JsonProperty(value="count_reopens")
    public Optional<Integer> getCountReopens() {
        return this.countReopens;
    }

    @JsonProperty(value="count_assignments")
    public Optional<Integer> getCountAssignments() {
        return this.countAssignments;
    }

    @JsonProperty(value="count_conversation_parts")
    public Optional<Integer> getCountConversationParts() {
        return this.countConversationParts;
    }

    @JsonProperty(value="assigned_team_first_response_time_by_team")
    public Optional<List<ConversationResponseTime>> getAssignedTeamFirstResponseTimeByTeam() {
        return this.assignedTeamFirstResponseTimeByTeam;
    }

    @JsonProperty(value="assigned_team_first_response_time_in_office_hours")
    public Optional<List<ConversationResponseTime>> getAssignedTeamFirstResponseTimeInOfficeHours() {
        return this.assignedTeamFirstResponseTimeInOfficeHours;
    }

    @JsonProperty(value="handling_time")
    public Optional<Integer> getHandlingTime() {
        return this.handlingTime;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConversationStatistics && this.equalTo((ConversationStatistics)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationStatistics other) {
        return this.type.equals(other.type) && this.timeToAssignment.equals(other.timeToAssignment) && this.timeToAdminReply.equals(other.timeToAdminReply) && this.timeToFirstClose.equals(other.timeToFirstClose) && this.timeToLastClose.equals(other.timeToLastClose) && this.medianTimeToReply.equals(other.medianTimeToReply) && this.firstContactReplyAt.equals(other.firstContactReplyAt) && this.firstAssignmentAt.equals(other.firstAssignmentAt) && this.firstAdminReplyAt.equals(other.firstAdminReplyAt) && this.firstCloseAt.equals(other.firstCloseAt) && this.lastAssignmentAt.equals(other.lastAssignmentAt) && this.lastAssignmentAdminReplyAt.equals(other.lastAssignmentAdminReplyAt) && this.lastContactReplyAt.equals(other.lastContactReplyAt) && this.lastAdminReplyAt.equals(other.lastAdminReplyAt) && this.lastCloseAt.equals(other.lastCloseAt) && this.lastClosedById.equals(other.lastClosedById) && this.countReopens.equals(other.countReopens) && this.countAssignments.equals(other.countAssignments) && this.countConversationParts.equals(other.countConversationParts) && this.assignedTeamFirstResponseTimeByTeam.equals(other.assignedTeamFirstResponseTimeByTeam) && this.assignedTeamFirstResponseTimeInOfficeHours.equals(other.assignedTeamFirstResponseTimeInOfficeHours) && this.handlingTime.equals(other.handlingTime);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.timeToAssignment, this.timeToAdminReply, this.timeToFirstClose, this.timeToLastClose, this.medianTimeToReply, this.firstContactReplyAt, this.firstAssignmentAt, this.firstAdminReplyAt, this.firstCloseAt, this.lastAssignmentAt, this.lastAssignmentAdminReplyAt, this.lastContactReplyAt, this.lastAdminReplyAt, this.lastCloseAt, this.lastClosedById, this.countReopens, this.countAssignments, this.countConversationParts, this.assignedTeamFirstResponseTimeByTeam, this.assignedTeamFirstResponseTimeInOfficeHours, this.handlingTime);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<Integer> timeToAssignment = Optional.empty();
        private Optional<Integer> timeToAdminReply = Optional.empty();
        private Optional<Integer> timeToFirstClose = Optional.empty();
        private Optional<Integer> timeToLastClose = Optional.empty();
        private Optional<Integer> medianTimeToReply = Optional.empty();
        private Optional<Integer> firstContactReplyAt = Optional.empty();
        private Optional<Integer> firstAssignmentAt = Optional.empty();
        private Optional<Integer> firstAdminReplyAt = Optional.empty();
        private Optional<Integer> firstCloseAt = Optional.empty();
        private Optional<Integer> lastAssignmentAt = Optional.empty();
        private Optional<Integer> lastAssignmentAdminReplyAt = Optional.empty();
        private Optional<Integer> lastContactReplyAt = Optional.empty();
        private Optional<Integer> lastAdminReplyAt = Optional.empty();
        private Optional<Integer> lastCloseAt = Optional.empty();
        private Optional<String> lastClosedById = Optional.empty();
        private Optional<Integer> countReopens = Optional.empty();
        private Optional<Integer> countAssignments = Optional.empty();
        private Optional<Integer> countConversationParts = Optional.empty();
        private Optional<List<ConversationResponseTime>> assignedTeamFirstResponseTimeByTeam = Optional.empty();
        private Optional<List<ConversationResponseTime>> assignedTeamFirstResponseTimeInOfficeHours = Optional.empty();
        private Optional<Integer> handlingTime = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ConversationStatistics other) {
            this.type(other.getType());
            this.timeToAssignment(other.getTimeToAssignment());
            this.timeToAdminReply(other.getTimeToAdminReply());
            this.timeToFirstClose(other.getTimeToFirstClose());
            this.timeToLastClose(other.getTimeToLastClose());
            this.medianTimeToReply(other.getMedianTimeToReply());
            this.firstContactReplyAt(other.getFirstContactReplyAt());
            this.firstAssignmentAt(other.getFirstAssignmentAt());
            this.firstAdminReplyAt(other.getFirstAdminReplyAt());
            this.firstCloseAt(other.getFirstCloseAt());
            this.lastAssignmentAt(other.getLastAssignmentAt());
            this.lastAssignmentAdminReplyAt(other.getLastAssignmentAdminReplyAt());
            this.lastContactReplyAt(other.getLastContactReplyAt());
            this.lastAdminReplyAt(other.getLastAdminReplyAt());
            this.lastCloseAt(other.getLastCloseAt());
            this.lastClosedById(other.getLastClosedById());
            this.countReopens(other.getCountReopens());
            this.countAssignments(other.getCountAssignments());
            this.countConversationParts(other.getCountConversationParts());
            this.assignedTeamFirstResponseTimeByTeam(other.getAssignedTeamFirstResponseTimeByTeam());
            this.assignedTeamFirstResponseTimeInOfficeHours(other.getAssignedTeamFirstResponseTimeInOfficeHours());
            this.handlingTime(other.getHandlingTime());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="time_to_assignment", nulls=Nulls.SKIP)
        public Builder timeToAssignment(Optional<Integer> timeToAssignment) {
            this.timeToAssignment = timeToAssignment;
            return this;
        }

        public Builder timeToAssignment(Integer timeToAssignment) {
            this.timeToAssignment = Optional.ofNullable(timeToAssignment);
            return this;
        }

        @JsonSetter(value="time_to_admin_reply", nulls=Nulls.SKIP)
        public Builder timeToAdminReply(Optional<Integer> timeToAdminReply) {
            this.timeToAdminReply = timeToAdminReply;
            return this;
        }

        public Builder timeToAdminReply(Integer timeToAdminReply) {
            this.timeToAdminReply = Optional.ofNullable(timeToAdminReply);
            return this;
        }

        @JsonSetter(value="time_to_first_close", nulls=Nulls.SKIP)
        public Builder timeToFirstClose(Optional<Integer> timeToFirstClose) {
            this.timeToFirstClose = timeToFirstClose;
            return this;
        }

        public Builder timeToFirstClose(Integer timeToFirstClose) {
            this.timeToFirstClose = Optional.ofNullable(timeToFirstClose);
            return this;
        }

        @JsonSetter(value="time_to_last_close", nulls=Nulls.SKIP)
        public Builder timeToLastClose(Optional<Integer> timeToLastClose) {
            this.timeToLastClose = timeToLastClose;
            return this;
        }

        public Builder timeToLastClose(Integer timeToLastClose) {
            this.timeToLastClose = Optional.ofNullable(timeToLastClose);
            return this;
        }

        @JsonSetter(value="median_time_to_reply", nulls=Nulls.SKIP)
        public Builder medianTimeToReply(Optional<Integer> medianTimeToReply) {
            this.medianTimeToReply = medianTimeToReply;
            return this;
        }

        public Builder medianTimeToReply(Integer medianTimeToReply) {
            this.medianTimeToReply = Optional.ofNullable(medianTimeToReply);
            return this;
        }

        @JsonSetter(value="first_contact_reply_at", nulls=Nulls.SKIP)
        public Builder firstContactReplyAt(Optional<Integer> firstContactReplyAt) {
            this.firstContactReplyAt = firstContactReplyAt;
            return this;
        }

        public Builder firstContactReplyAt(Integer firstContactReplyAt) {
            this.firstContactReplyAt = Optional.ofNullable(firstContactReplyAt);
            return this;
        }

        @JsonSetter(value="first_assignment_at", nulls=Nulls.SKIP)
        public Builder firstAssignmentAt(Optional<Integer> firstAssignmentAt) {
            this.firstAssignmentAt = firstAssignmentAt;
            return this;
        }

        public Builder firstAssignmentAt(Integer firstAssignmentAt) {
            this.firstAssignmentAt = Optional.ofNullable(firstAssignmentAt);
            return this;
        }

        @JsonSetter(value="first_admin_reply_at", nulls=Nulls.SKIP)
        public Builder firstAdminReplyAt(Optional<Integer> firstAdminReplyAt) {
            this.firstAdminReplyAt = firstAdminReplyAt;
            return this;
        }

        public Builder firstAdminReplyAt(Integer firstAdminReplyAt) {
            this.firstAdminReplyAt = Optional.ofNullable(firstAdminReplyAt);
            return this;
        }

        @JsonSetter(value="first_close_at", nulls=Nulls.SKIP)
        public Builder firstCloseAt(Optional<Integer> firstCloseAt) {
            this.firstCloseAt = firstCloseAt;
            return this;
        }

        public Builder firstCloseAt(Integer firstCloseAt) {
            this.firstCloseAt = Optional.ofNullable(firstCloseAt);
            return this;
        }

        @JsonSetter(value="last_assignment_at", nulls=Nulls.SKIP)
        public Builder lastAssignmentAt(Optional<Integer> lastAssignmentAt) {
            this.lastAssignmentAt = lastAssignmentAt;
            return this;
        }

        public Builder lastAssignmentAt(Integer lastAssignmentAt) {
            this.lastAssignmentAt = Optional.ofNullable(lastAssignmentAt);
            return this;
        }

        @JsonSetter(value="last_assignment_admin_reply_at", nulls=Nulls.SKIP)
        public Builder lastAssignmentAdminReplyAt(Optional<Integer> lastAssignmentAdminReplyAt) {
            this.lastAssignmentAdminReplyAt = lastAssignmentAdminReplyAt;
            return this;
        }

        public Builder lastAssignmentAdminReplyAt(Integer lastAssignmentAdminReplyAt) {
            this.lastAssignmentAdminReplyAt = Optional.ofNullable(lastAssignmentAdminReplyAt);
            return this;
        }

        @JsonSetter(value="last_contact_reply_at", nulls=Nulls.SKIP)
        public Builder lastContactReplyAt(Optional<Integer> lastContactReplyAt) {
            this.lastContactReplyAt = lastContactReplyAt;
            return this;
        }

        public Builder lastContactReplyAt(Integer lastContactReplyAt) {
            this.lastContactReplyAt = Optional.ofNullable(lastContactReplyAt);
            return this;
        }

        @JsonSetter(value="last_admin_reply_at", nulls=Nulls.SKIP)
        public Builder lastAdminReplyAt(Optional<Integer> lastAdminReplyAt) {
            this.lastAdminReplyAt = lastAdminReplyAt;
            return this;
        }

        public Builder lastAdminReplyAt(Integer lastAdminReplyAt) {
            this.lastAdminReplyAt = Optional.ofNullable(lastAdminReplyAt);
            return this;
        }

        @JsonSetter(value="last_close_at", nulls=Nulls.SKIP)
        public Builder lastCloseAt(Optional<Integer> lastCloseAt) {
            this.lastCloseAt = lastCloseAt;
            return this;
        }

        public Builder lastCloseAt(Integer lastCloseAt) {
            this.lastCloseAt = Optional.ofNullable(lastCloseAt);
            return this;
        }

        @JsonSetter(value="last_closed_by_id", nulls=Nulls.SKIP)
        public Builder lastClosedById(Optional<String> lastClosedById) {
            this.lastClosedById = lastClosedById;
            return this;
        }

        public Builder lastClosedById(String lastClosedById) {
            this.lastClosedById = Optional.ofNullable(lastClosedById);
            return this;
        }

        @JsonSetter(value="count_reopens", nulls=Nulls.SKIP)
        public Builder countReopens(Optional<Integer> countReopens) {
            this.countReopens = countReopens;
            return this;
        }

        public Builder countReopens(Integer countReopens) {
            this.countReopens = Optional.ofNullable(countReopens);
            return this;
        }

        @JsonSetter(value="count_assignments", nulls=Nulls.SKIP)
        public Builder countAssignments(Optional<Integer> countAssignments) {
            this.countAssignments = countAssignments;
            return this;
        }

        public Builder countAssignments(Integer countAssignments) {
            this.countAssignments = Optional.ofNullable(countAssignments);
            return this;
        }

        @JsonSetter(value="count_conversation_parts", nulls=Nulls.SKIP)
        public Builder countConversationParts(Optional<Integer> countConversationParts) {
            this.countConversationParts = countConversationParts;
            return this;
        }

        public Builder countConversationParts(Integer countConversationParts) {
            this.countConversationParts = Optional.ofNullable(countConversationParts);
            return this;
        }

        @JsonSetter(value="assigned_team_first_response_time_by_team", nulls=Nulls.SKIP)
        public Builder assignedTeamFirstResponseTimeByTeam(Optional<List<ConversationResponseTime>> assignedTeamFirstResponseTimeByTeam) {
            this.assignedTeamFirstResponseTimeByTeam = assignedTeamFirstResponseTimeByTeam;
            return this;
        }

        public Builder assignedTeamFirstResponseTimeByTeam(List<ConversationResponseTime> assignedTeamFirstResponseTimeByTeam) {
            this.assignedTeamFirstResponseTimeByTeam = Optional.ofNullable(assignedTeamFirstResponseTimeByTeam);
            return this;
        }

        @JsonSetter(value="assigned_team_first_response_time_in_office_hours", nulls=Nulls.SKIP)
        public Builder assignedTeamFirstResponseTimeInOfficeHours(Optional<List<ConversationResponseTime>> assignedTeamFirstResponseTimeInOfficeHours) {
            this.assignedTeamFirstResponseTimeInOfficeHours = assignedTeamFirstResponseTimeInOfficeHours;
            return this;
        }

        public Builder assignedTeamFirstResponseTimeInOfficeHours(List<ConversationResponseTime> assignedTeamFirstResponseTimeInOfficeHours) {
            this.assignedTeamFirstResponseTimeInOfficeHours = Optional.ofNullable(assignedTeamFirstResponseTimeInOfficeHours);
            return this;
        }

        @JsonSetter(value="handling_time", nulls=Nulls.SKIP)
        public Builder handlingTime(Optional<Integer> handlingTime) {
            this.handlingTime = handlingTime;
            return this;
        }

        public Builder handlingTime(Integer handlingTime) {
            this.handlingTime = Optional.ofNullable(handlingTime);
            return this;
        }

        public ConversationStatistics build() {
            return new ConversationStatistics(this.type, this.timeToAssignment, this.timeToAdminReply, this.timeToFirstClose, this.timeToLastClose, this.medianTimeToReply, this.firstContactReplyAt, this.firstAssignmentAt, this.firstAdminReplyAt, this.firstCloseAt, this.lastAssignmentAt, this.lastAssignmentAdminReplyAt, this.lastContactReplyAt, this.lastAdminReplyAt, this.lastCloseAt, this.lastClosedById, this.countReopens, this.countAssignments, this.countConversationParts, this.assignedTeamFirstResponseTimeByTeam, this.assignedTeamFirstResponseTimeInOfficeHours, this.handlingTime, this.additionalProperties);
        }
    }
}

