/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CustomChannelNotificationResponse {
    private final String externalConversationId;
    private final String conversationId;
    private final String externalContactId;
    private final String contactId;
    private final Map<String, Object> additionalProperties;

    private CustomChannelNotificationResponse(String externalConversationId, String conversationId, String externalContactId, String contactId, Map<String, Object> additionalProperties) {
        this.externalConversationId = externalConversationId;
        this.conversationId = conversationId;
        this.externalContactId = externalContactId;
        this.contactId = contactId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="external_conversation_id")
    public String getExternalConversationId() {
        return this.externalConversationId;
    }

    @JsonProperty(value="conversation_id")
    public String getConversationId() {
        return this.conversationId;
    }

    @JsonProperty(value="external_contact_id")
    public String getExternalContactId() {
        return this.externalContactId;
    }

    @JsonProperty(value="contact_id")
    public String getContactId() {
        return this.contactId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CustomChannelNotificationResponse && this.equalTo((CustomChannelNotificationResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CustomChannelNotificationResponse other) {
        return this.externalConversationId.equals(other.externalConversationId) && this.conversationId.equals(other.conversationId) && this.externalContactId.equals(other.externalContactId) && this.contactId.equals(other.contactId);
    }

    public int hashCode() {
        return Objects.hash(this.externalConversationId, this.conversationId, this.externalContactId, this.contactId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ExternalConversationIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ExternalConversationIdStage,
    ConversationIdStage,
    ExternalContactIdStage,
    ContactIdStage,
    _FinalStage {
        private String externalConversationId;
        private String conversationId;
        private String externalContactId;
        private String contactId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CustomChannelNotificationResponse other) {
            this.externalConversationId(other.getExternalConversationId());
            this.conversationId(other.getConversationId());
            this.externalContactId(other.getExternalContactId());
            this.contactId(other.getContactId());
            return this;
        }

        @Override
        @JsonSetter(value="external_conversation_id")
        public ConversationIdStage externalConversationId(@NotNull String externalConversationId) {
            this.externalConversationId = Objects.requireNonNull(externalConversationId, "externalConversationId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="conversation_id")
        public ExternalContactIdStage conversationId(@NotNull String conversationId) {
            this.conversationId = Objects.requireNonNull(conversationId, "conversationId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="external_contact_id")
        public ContactIdStage externalContactId(@NotNull String externalContactId) {
            this.externalContactId = Objects.requireNonNull(externalContactId, "externalContactId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="contact_id")
        public _FinalStage contactId(@NotNull String contactId) {
            this.contactId = Objects.requireNonNull(contactId, "contactId must not be null");
            return this;
        }

        @Override
        public CustomChannelNotificationResponse build() {
            return new CustomChannelNotificationResponse(this.externalConversationId, this.conversationId, this.externalContactId, this.contactId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CustomChannelNotificationResponse build();
    }

    public static interface ContactIdStage {
        public _FinalStage contactId(@NotNull String var1);
    }

    public static interface ExternalContactIdStage {
        public ContactIdStage externalContactId(@NotNull String var1);
    }

    public static interface ConversationIdStage {
        public ExternalContactIdStage conversationId(@NotNull String var1);
    }

    public static interface ExternalConversationIdStage {
        public ConversationIdStage externalConversationId(@NotNull String var1);

        public Builder from(CustomChannelNotificationResponse var1);
    }
}

