/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.EmailAddressHeader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class EmailMessageMetadata {
    private final Optional<String> subject;
    private final Optional<List<EmailAddressHeader>> emailAddressHeaders;
    private final Map<String, Object> additionalProperties;

    private EmailMessageMetadata(Optional<String> subject, Optional<List<EmailAddressHeader>> emailAddressHeaders, Map<String, Object> additionalProperties) {
        this.subject = subject;
        this.emailAddressHeaders = emailAddressHeaders;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="subject")
    public Optional<String> getSubject() {
        return this.subject;
    }

    @JsonProperty(value="email_address_headers")
    public Optional<List<EmailAddressHeader>> getEmailAddressHeaders() {
        return this.emailAddressHeaders;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof EmailMessageMetadata && this.equalTo((EmailMessageMetadata)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(EmailMessageMetadata other) {
        return this.subject.equals(other.subject) && this.emailAddressHeaders.equals(other.emailAddressHeaders);
    }

    public int hashCode() {
        return Objects.hash(this.subject, this.emailAddressHeaders);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> subject = Optional.empty();
        private Optional<List<EmailAddressHeader>> emailAddressHeaders = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(EmailMessageMetadata other) {
            this.subject(other.getSubject());
            this.emailAddressHeaders(other.getEmailAddressHeaders());
            return this;
        }

        @JsonSetter(value="subject", nulls=Nulls.SKIP)
        public Builder subject(Optional<String> subject) {
            this.subject = subject;
            return this;
        }

        public Builder subject(String subject) {
            this.subject = Optional.ofNullable(subject);
            return this;
        }

        @JsonSetter(value="email_address_headers", nulls=Nulls.SKIP)
        public Builder emailAddressHeaders(Optional<List<EmailAddressHeader>> emailAddressHeaders) {
            this.emailAddressHeaders = emailAddressHeaders;
            return this;
        }

        public Builder emailAddressHeaders(List<EmailAddressHeader> emailAddressHeaders) {
            this.emailAddressHeaders = Optional.ofNullable(emailAddressHeaders);
            return this;
        }

        public EmailMessageMetadata build() {
            return new EmailMessageMetadata(this.subject, this.emailAddressHeaders, this.additionalProperties);
        }
    }
}

