/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LinkedObject {
    private final Optional<Type> type;
    private final Optional<String> id;
    private final Optional<String> category;
    private final Map<String, Object> additionalProperties;

    private LinkedObject(Optional<Type> type, Optional<String> id, Optional<String> category, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.category = category;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<Type> getType() {
        return this.type;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="category")
    public Optional<String> getCategory() {
        return this.category;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LinkedObject && this.equalTo((LinkedObject)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LinkedObject other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.category.equals(other.category);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.category);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Type {
        public static final Type TICKET = new Type(Value.TICKET, "ticket");
        public static final Type CONVERSATION = new Type(Value.CONVERSATION, "conversation");
        private final Value value;
        private final String string;

        Type(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Type && this.string.equals(((Type)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case TICKET: {
                    return visitor.visitTicket();
                }
                case CONVERSATION: {
                    return visitor.visitConversation();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static Type valueOf(String value) {
            switch (value) {
                case "ticket": {
                    return TICKET;
                }
                case "conversation": {
                    return CONVERSATION;
                }
            }
            return new Type(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitTicket();

            public T visitConversation();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            TICKET,
            CONVERSATION,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Type> type = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Optional<String> category = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(LinkedObject other) {
            this.type(other.getType());
            this.id(other.getId());
            this.category(other.getCategory());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<Type> type) {
            this.type = type;
            return this;
        }

        public Builder type(Type type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="category", nulls=Nulls.SKIP)
        public Builder category(Optional<String> category) {
            this.category = category;
            return this;
        }

        public Builder category(String category) {
            this.category = Optional.ofNullable(category);
            return this;
        }

        public LinkedObject build() {
            return new LinkedObject(this.type, this.id, this.category, this.additionalProperties);
        }
    }
}

