/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.CursorPages;
import com.intercom.api.resources.unstable.types.PaginatedResponseDataItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PaginatedResponse {
    private final Optional<Type> type;
    private final Optional<CursorPages> pages;
    private final Optional<Integer> totalCount;
    private final Optional<List<PaginatedResponseDataItem>> data;
    private final Map<String, Object> additionalProperties;

    private PaginatedResponse(Optional<Type> type, Optional<CursorPages> pages, Optional<Integer> totalCount, Optional<List<PaginatedResponseDataItem>> data, Map<String, Object> additionalProperties) {
        this.type = type;
        this.pages = pages;
        this.totalCount = totalCount;
        this.data = data;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<Type> getType() {
        return this.type;
    }

    @JsonProperty(value="pages")
    public Optional<CursorPages> getPages() {
        return this.pages;
    }

    @JsonProperty(value="total_count")
    public Optional<Integer> getTotalCount() {
        return this.totalCount;
    }

    @JsonProperty(value="data")
    public Optional<List<PaginatedResponseDataItem>> getData() {
        return this.data;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PaginatedResponse && this.equalTo((PaginatedResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PaginatedResponse other) {
        return this.type.equals(other.type) && this.pages.equals(other.pages) && this.totalCount.equals(other.totalCount) && this.data.equals(other.data);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.pages, this.totalCount, this.data);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Type {
        public static final Type LIST = new Type(Value.LIST, "list");
        public static final Type CONVERSATION_LIST = new Type(Value.CONVERSATION_LIST, "conversation.list");
        private final Value value;
        private final String string;

        Type(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Type && this.string.equals(((Type)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case LIST: {
                    return visitor.visitList();
                }
                case CONVERSATION_LIST: {
                    return visitor.visitConversationList();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static Type valueOf(String value) {
            switch (value) {
                case "list": {
                    return LIST;
                }
                case "conversation.list": {
                    return CONVERSATION_LIST;
                }
            }
            return new Type(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitList();

            public T visitConversationList();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            LIST,
            CONVERSATION_LIST,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Type> type = Optional.empty();
        private Optional<CursorPages> pages = Optional.empty();
        private Optional<Integer> totalCount = Optional.empty();
        private Optional<List<PaginatedResponseDataItem>> data = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(PaginatedResponse other) {
            this.type(other.getType());
            this.pages(other.getPages());
            this.totalCount(other.getTotalCount());
            this.data(other.getData());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<Type> type) {
            this.type = type;
            return this;
        }

        public Builder type(Type type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="pages", nulls=Nulls.SKIP)
        public Builder pages(Optional<CursorPages> pages) {
            this.pages = pages;
            return this;
        }

        public Builder pages(CursorPages pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        @JsonSetter(value="total_count", nulls=Nulls.SKIP)
        public Builder totalCount(Optional<Integer> totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public Builder totalCount(Integer totalCount) {
            this.totalCount = Optional.ofNullable(totalCount);
            return this;
        }

        @JsonSetter(value="data", nulls=Nulls.SKIP)
        public Builder data(Optional<List<PaginatedResponseDataItem>> data) {
            this.data = data;
            return this;
        }

        public Builder data(List<PaginatedResponseDataItem> data) {
            this.data = Optional.ofNullable(data);
            return this;
        }

        public PaginatedResponse build() {
            return new PaginatedResponse(this.type, this.pages, this.totalCount, this.data, this.additionalProperties);
        }
    }
}

