/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import com.intercom.api.types.SheetActionComponent;
import com.intercom.api.types.SubmitActionComponent;
import com.intercom.api.types.UrlActionComponent;
import java.util.Objects;
import java.util.Optional;

public final class ActionComponent {
    private final Value value;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    private ActionComponent(Value value) {
        this.value = value;
    }

    public <T> T visit(Visitor<T> visitor) {
        return this.value.visit(visitor);
    }

    public static ActionComponent sheet(SheetActionComponent value) {
        return new ActionComponent(new SheetValue(value));
    }

    public static ActionComponent url(UrlActionComponent value) {
        return new ActionComponent(new UrlValue(value));
    }

    public static ActionComponent submit(SubmitActionComponent value) {
        return new ActionComponent(new SubmitValue(value));
    }

    public boolean isSheet() {
        return this.value instanceof SheetValue;
    }

    public boolean isUrl() {
        return this.value instanceof UrlValue;
    }

    public boolean isSubmit() {
        return this.value instanceof SubmitValue;
    }

    public boolean _isUnknown() {
        return this.value instanceof _UnknownValue;
    }

    public Optional<SheetActionComponent> getSheet() {
        if (this.isSheet()) {
            return Optional.of(((SheetValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<UrlActionComponent> getUrl() {
        if (this.isUrl()) {
            return Optional.of(((UrlValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<SubmitActionComponent> getSubmit() {
        if (this.isSubmit()) {
            return Optional.of(((SubmitValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<Object> _getUnknown() {
        if (this._isUnknown()) {
            return Optional.of(((_UnknownValue)this.value).value);
        }
        return Optional.empty();
    }

    @JsonValue
    private Value getValue() {
        return this.value;
    }

    @JsonIgnoreProperties(value={"type"})
    private static final class _UnknownValue
    implements Value {
        private String type;
        @JsonValue
        private Object value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private _UnknownValue(@JsonProperty(value="value") Object value) {
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor._visitUnknown(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof _UnknownValue && this.equalTo((_UnknownValue)other);
        }

        private boolean equalTo(_UnknownValue other) {
            return this.type.equals(other.type) && this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        public String toString() {
            return "ActionComponent{type: " + this.type + ", value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="submit")
    @JsonIgnoreProperties(value={"type"})
    private static final class SubmitValue
    implements Value {
        @JsonUnwrapped
        private SubmitActionComponent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private SubmitValue() {
        }

        private SubmitValue(SubmitActionComponent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitSubmit(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof SubmitValue && this.equalTo((SubmitValue)other);
        }

        private boolean equalTo(SubmitValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "ActionComponent{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="url")
    @JsonIgnoreProperties(value={"type"})
    private static final class UrlValue
    implements Value {
        @JsonUnwrapped
        private UrlActionComponent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private UrlValue() {
        }

        private UrlValue(UrlActionComponent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitUrl(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof UrlValue && this.equalTo((UrlValue)other);
        }

        private boolean equalTo(UrlValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "ActionComponent{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="sheet")
    @JsonIgnoreProperties(value={"type"})
    private static final class SheetValue
    implements Value {
        @JsonUnwrapped
        private SheetActionComponent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private SheetValue() {
        }

        private SheetValue(SheetActionComponent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitSheet(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof SheetValue && this.equalTo((SheetValue)other);
        }

        private boolean equalTo(SheetValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "ActionComponent{value: " + this.value + "}";
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", visible=true, defaultImpl=_UnknownValue.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=SheetValue.class), @JsonSubTypes.Type(value=UrlValue.class), @JsonSubTypes.Type(value=SubmitValue.class)})
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static interface Value {
        public <T> T visit(Visitor<T> var1);
    }

    public static interface Visitor<T> {
        public T visitSheet(SheetActionComponent var1);

        public T visitUrl(UrlActionComponent var1);

        public T visitSubmit(SubmitActionComponent var1);

        public T _visitUnknown(Object var1);
    }
}

