/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.ContentObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CanvasObject {
    private final ContentObject content;
    private final Optional<String> contentUrl;
    private final Optional<Map<String, Object>> storedData;
    private final Map<String, Object> additionalProperties;

    private CanvasObject(ContentObject content, Optional<String> contentUrl, Optional<Map<String, Object>> storedData, Map<String, Object> additionalProperties) {
        this.content = content;
        this.contentUrl = contentUrl;
        this.storedData = storedData;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="content")
    public ContentObject getContent() {
        return this.content;
    }

    @JsonProperty(value="content_url")
    public Optional<String> getContentUrl() {
        return this.contentUrl;
    }

    @JsonProperty(value="stored_data")
    public Optional<Map<String, Object>> getStoredData() {
        return this.storedData;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CanvasObject && this.equalTo((CanvasObject)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CanvasObject other) {
        return this.content.equals(other.content) && this.contentUrl.equals(other.contentUrl) && this.storedData.equals(other.storedData);
    }

    public int hashCode() {
        return Objects.hash(this.content, this.contentUrl, this.storedData);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ContentStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ContentStage,
    _FinalStage {
        private ContentObject content;
        private Optional<Map<String, Object>> storedData = Optional.empty();
        private Optional<String> contentUrl = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CanvasObject other) {
            this.content(other.getContent());
            this.contentUrl(other.getContentUrl());
            this.storedData(other.getStoredData());
            return this;
        }

        @Override
        @JsonSetter(value="content")
        public _FinalStage content(@NotNull ContentObject content) {
            this.content = Objects.requireNonNull(content, "content must not be null");
            return this;
        }

        @Override
        public _FinalStage storedData(Map<String, Object> storedData) {
            this.storedData = Optional.ofNullable(storedData);
            return this;
        }

        @Override
        @JsonSetter(value="stored_data", nulls=Nulls.SKIP)
        public _FinalStage storedData(Optional<Map<String, Object>> storedData) {
            this.storedData = storedData;
            return this;
        }

        @Override
        public _FinalStage contentUrl(String contentUrl) {
            this.contentUrl = Optional.ofNullable(contentUrl);
            return this;
        }

        @Override
        @JsonSetter(value="content_url", nulls=Nulls.SKIP)
        public _FinalStage contentUrl(Optional<String> contentUrl) {
            this.contentUrl = contentUrl;
            return this;
        }

        @Override
        public CanvasObject build() {
            return new CanvasObject(this.content, this.contentUrl, this.storedData, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CanvasObject build();

        public _FinalStage contentUrl(Optional<String> var1);

        public _FinalStage contentUrl(String var1);

        public _FinalStage storedData(Optional<Map<String, Object>> var1);

        public _FinalStage storedData(Map<String, Object> var1);
    }

    public static interface ContentStage {
        public _FinalStage content(@NotNull ContentObject var1);

        public Builder from(CanvasObject var1);
    }
}

