/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ContentObject {
    private final List<Component> components;
    private final Map<String, Object> additionalProperties;

    private ContentObject(List<Component> components, Map<String, Object> additionalProperties) {
        this.components = components;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="components")
    public List<Component> getComponents() {
        return this.components;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ContentObject && this.equalTo((ContentObject)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContentObject other) {
        return this.components.equals(other.components);
    }

    public int hashCode() {
        return Objects.hash(this.components);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private List<Component> components = new ArrayList<Component>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ContentObject other) {
            this.components(other.getComponents());
            return this;
        }

        @JsonSetter(value="components", nulls=Nulls.SKIP)
        public Builder components(List<Component> components) {
            this.components.clear();
            this.components.addAll(components);
            return this;
        }

        public Builder addComponents(Component components) {
            this.components.add(components);
            return this;
        }

        public Builder addAllComponents(List<Component> components) {
            this.components.addAll(components);
            return this;
        }

        public ContentObject build() {
            return new ContentObject(this.components, this.additionalProperties);
        }
    }
}

