/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DropdownOption {
    private final String id;
    private final String text;
    private final Optional<Boolean> disabled;
    private final Map<String, Object> additionalProperties;

    private DropdownOption(String id, String text, Optional<Boolean> disabled, Map<String, Object> additionalProperties) {
        this.id = id;
        this.text = text;
        this.disabled = disabled;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "option";
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="disabled")
    public Optional<Boolean> getDisabled() {
        return this.disabled;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DropdownOption && this.equalTo((DropdownOption)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DropdownOption other) {
        return this.id.equals(other.id) && this.text.equals(other.text) && this.disabled.equals(other.disabled);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.text, this.disabled);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    TextStage,
    _FinalStage {
        private String id;
        private String text;
        private Optional<Boolean> disabled = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DropdownOption other) {
            this.id(other.getId());
            this.text(other.getText());
            this.disabled(other.getDisabled());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public TextStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="text")
        public _FinalStage text(@NotNull String text) {
            this.text = Objects.requireNonNull(text, "text must not be null");
            return this;
        }

        @Override
        public _FinalStage disabled(Boolean disabled) {
            this.disabled = Optional.ofNullable(disabled);
            return this;
        }

        @Override
        @JsonSetter(value="disabled", nulls=Nulls.SKIP)
        public _FinalStage disabled(Optional<Boolean> disabled) {
            this.disabled = disabled;
            return this;
        }

        @Override
        public DropdownOption build() {
            return new DropdownOption(this.id, this.text, this.disabled, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DropdownOption build();

        public _FinalStage disabled(Optional<Boolean> var1);

        public _FinalStage disabled(Boolean var1);
    }

    public static interface TextStage {
        public _FinalStage text(@NotNull String var1);
    }

    public static interface IdStage {
        public TextStage id(@NotNull String var1);

        public Builder from(DropdownOption var1);
    }
}

