/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.news.types.Newsfeed;
import com.intercom.api.types.CursorPages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PaginatedNewsfeedResponse {
    private final Optional<CursorPages> pages;
    private final int totalCount;
    private final List<Newsfeed> data;
    private final Map<String, Object> additionalProperties;

    private PaginatedNewsfeedResponse(Optional<CursorPages> pages, int totalCount, List<Newsfeed> data, Map<String, Object> additionalProperties) {
        this.pages = pages;
        this.totalCount = totalCount;
        this.data = data;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "list";
    }

    @JsonProperty(value="pages")
    public Optional<CursorPages> getPages() {
        return this.pages;
    }

    @JsonProperty(value="total_count")
    public int getTotalCount() {
        return this.totalCount;
    }

    @JsonProperty(value="data")
    public List<Newsfeed> getData() {
        return this.data;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PaginatedNewsfeedResponse && this.equalTo((PaginatedNewsfeedResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PaginatedNewsfeedResponse other) {
        return this.pages.equals(other.pages) && this.totalCount == other.totalCount && this.data.equals(other.data);
    }

    public int hashCode() {
        return Objects.hash(this.pages, this.totalCount, this.data);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TotalCountStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TotalCountStage,
    _FinalStage {
        private int totalCount;
        private List<Newsfeed> data = new ArrayList<Newsfeed>();
        private Optional<CursorPages> pages = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PaginatedNewsfeedResponse other) {
            this.pages(other.getPages());
            this.totalCount(other.getTotalCount());
            this.data(other.getData());
            return this;
        }

        @Override
        @JsonSetter(value="total_count")
        public _FinalStage totalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @Override
        public _FinalStage addAllData(List<Newsfeed> data) {
            this.data.addAll(data);
            return this;
        }

        @Override
        public _FinalStage addData(Newsfeed data) {
            this.data.add(data);
            return this;
        }

        @Override
        @JsonSetter(value="data", nulls=Nulls.SKIP)
        public _FinalStage data(List<Newsfeed> data) {
            this.data.clear();
            this.data.addAll(data);
            return this;
        }

        @Override
        public _FinalStage pages(CursorPages pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        @Override
        @JsonSetter(value="pages", nulls=Nulls.SKIP)
        public _FinalStage pages(Optional<CursorPages> pages) {
            this.pages = pages;
            return this;
        }

        @Override
        public PaginatedNewsfeedResponse build() {
            return new PaginatedNewsfeedResponse(this.pages, this.totalCount, this.data, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PaginatedNewsfeedResponse build();

        public _FinalStage pages(Optional<CursorPages> var1);

        public _FinalStage pages(CursorPages var1);

        public _FinalStage data(List<Newsfeed> var1);

        public _FinalStage addData(Newsfeed var1);

        public _FinalStage addAllData(List<Newsfeed> var1);
    }

    public static interface TotalCountStage {
        public _FinalStage totalCount(int var1);

        public Builder from(PaginatedNewsfeedResponse var1);
    }
}

