/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Translation {
    private final String name;
    private final String description;
    private final String locale;
    private final Map<String, Object> additionalProperties;

    private Translation(String name, String description, String locale, Map<String, Object> additionalProperties) {
        this.name = name;
        this.description = description;
        this.locale = locale;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="locale")
    public String getLocale() {
        return this.locale;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Translation && this.equalTo((Translation)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Translation other) {
        return this.name.equals(other.name) && this.description.equals(other.description) && this.locale.equals(other.locale);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.locale);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    DescriptionStage,
    LocaleStage,
    _FinalStage {
        private String name;
        private String description;
        private String locale;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Translation other) {
            this.name(other.getName());
            this.description(other.getDescription());
            this.locale(other.getLocale());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public DescriptionStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="description")
        public LocaleStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="locale")
        public _FinalStage locale(@NotNull String locale) {
            this.locale = Objects.requireNonNull(locale, "locale must not be null");
            return this;
        }

        @Override
        public Translation build() {
            return new Translation(this.name, this.description, this.locale, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Translation build();
    }

    public static interface LocaleStage {
        public _FinalStage locale(@NotNull String var1);
    }

    public static interface DescriptionStage {
        public LocaleStage description(@NotNull String var1);
    }

    public static interface NameStage {
        public DescriptionStage name(@NotNull String var1);

        public Builder from(Translation var1);
    }
}

