/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.core.pagination;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

/**
 * Skeleton implementation for custom asynchronous bidirectional pagination.
 *
 * THIS CLASS MUST BE IMPLEMENTED BY THE USER.
 *
 * This file is added to .fernignore and will not be regenerated.
 * Replace this skeleton implementation with your custom async pagination logic
 * that handles your API's specific pagination structure (e.g., HATEOAS links).
 *
 * Example implementation for HATEOAS-style async pagination:
 * <pre>{@code
 * public class AsyncCustomPager<T> implements BiDirectionalPage<T> {
 *     private final List<T> items;
 *     private final String nextUrl;
 *     private final String previousUrl;
 *     private final AsyncHttpClient client;
 *
 *     public AsyncCustomPager(Response<T> response, AsyncHttpClient client, ...) {
 *         this.items = response.getData();
 *         this.nextUrl = response.getLinks().getNext();
 *         this.previousUrl = response.getLinks().getPrevious();
 *         // ... store other needed context
 *     }
 *
 *     @Override
 *     public boolean hasNext() {
 *         return nextUrl != null;
 *     }
 *
 *     @Override
 *     public CompletableFuture<BiDirectionalPage<T>> nextPageAsync() {
 *         if (!hasNext()) {
 *             CompletableFuture<BiDirectionalPage<T>> future = new CompletableFuture<>();
 *             future.completeExceptionally(new NoSuchElementException("No next page available"));
 *             return future;
 *         }
 *         // Make async HTTP request to nextUrl
 *         return client.getAsync(nextUrl)
 *             .thenApply(response -> new AsyncCustomPager<>(response, client, ...));
 *     }
 *
 *     // ... implement other methods
 * }
 * }</pre>
 *
 * @param <T> The type of items in the page
 */
public class AsyncCustomPager<T> implements BiDirectionalPage<T> {

    /**
     * Create an AsyncCustomPager from an initial response.
     *
     * @param initialResponse The first page response from the API
     * @param client The async HTTP client to use for subsequent requests
     * @param requestOptions Request options for authentication, headers, etc.
     * @return A CompletableFuture containing the new AsyncCustomPager instance
     */
    public static <T> CompletableFuture<AsyncCustomPager<T>> createAsync(
            Object initialResponse, okhttp3.OkHttpClient client, Object requestOptions) {
        throw new UnsupportedOperationException("AsyncCustomPager must be implemented. "
                + "Please implement this class in core/AsyncCustomPager.java to define your async pagination logic. "
                + "This file has been added to .fernignore and will not be overwritten. "
                + "See the class documentation for implementation examples.");
    }

    @Override
    public boolean hasNext() {
        throw new UnsupportedOperationException("AsyncCustomPager.hasNext() must be implemented. "
                + "This method should return true if a next page is available.");
    }

    @Override
    public boolean hasPrevious() {
        throw new UnsupportedOperationException("AsyncCustomPager.hasPrevious() must be implemented. "
                + "This method should return true if a previous page is available.");
    }

    /**
     * Asynchronously fetch the next page.
     *
     * @return A CompletableFuture that completes with the next page
     * @throws java.util.NoSuchElementException if no next page exists (wrapped in CompletableFuture)
     */
    public CompletableFuture<BiDirectionalPage<T>> nextPageAsync() {
        CompletableFuture<BiDirectionalPage<T>> future = new CompletableFuture<>();
        future.completeExceptionally(
                new UnsupportedOperationException("AsyncCustomPager.nextPageAsync() must be implemented. "
                        + "This method should asynchronously fetch and return the next page of results."));
        return future;
    }

    /**
     * Asynchronously fetch the previous page.
     *
     * @return A CompletableFuture that completes with the previous page
     * @throws java.util.NoSuchElementException if no previous page exists (wrapped in CompletableFuture)
     */
    public CompletableFuture<BiDirectionalPage<T>> previousPageAsync() {
        CompletableFuture<BiDirectionalPage<T>> future = new CompletableFuture<>();
        future.completeExceptionally(
                new UnsupportedOperationException("AsyncCustomPager.previousPageAsync() must be implemented. "
                        + "This method should asynchronously fetch and return the previous page of results."));
        return future;
    }

    @Override
    public BiDirectionalPage<T> nextPage() throws IOException {
        throw new UnsupportedOperationException("AsyncCustomPager.nextPage() must be implemented. "
                + "Consider using nextPageAsync() for async operations, or implement synchronous blocking version.");
    }

    @Override
    public BiDirectionalPage<T> previousPage() throws IOException {
        throw new UnsupportedOperationException(
                "AsyncCustomPager.previousPage() must be implemented. "
                        + "Consider using previousPageAsync() for async operations, or implement synchronous blocking version.");
    }

    @Override
    public List<T> getItems() {
        throw new UnsupportedOperationException("AsyncCustomPager.getItems() must be implemented. "
                + "This method should return the items in the current page.");
    }

    @Override
    public <R> Optional<R> getResponse() {
        throw new UnsupportedOperationException("AsyncCustomPager.getResponse() must be implemented. "
                + "This method should return the full response object for accessing pagination metadata.");
    }

    /**
     * Asynchronously iterate through all pages starting from current.
     * Returns a CompletableFuture that completes with all items from all pages.
     *
     * @return CompletableFuture containing all items across all pages
     */
    public CompletableFuture<List<T>> getAllItemsAsync() {
        throw new UnsupportedOperationException("AsyncCustomPager.getAllItemsAsync() must be implemented. "
                + "This method should asynchronously fetch all pages and return all items.");
    }

    /**
     * Process each page asynchronously as it arrives.
     *
     * @param pageProcessor Function to process each page
     * @return CompletableFuture that completes when all pages are processed
     */
    public CompletableFuture<Void> forEachPageAsync(
            java.util.function.Function<List<T>, CompletionStage<Void>> pageProcessor) {
        throw new UnsupportedOperationException("AsyncCustomPager.forEachPageAsync() must be implemented. "
                + "This method should asynchronously process each page with the given function.");
    }
}
