/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.core.pagination;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

/**
 * Skeleton implementation for custom bidirectional pagination.
 *
 * THIS CLASS MUST BE IMPLEMENTED BY THE USER.
 *
 * This file is added to .fernignore and will not be regenerated.
 * Replace this skeleton implementation with your custom pagination logic
 * that handles your API's specific pagination structure (e.g., HATEOAS links).
 *
 * Example implementation for HATEOAS-style pagination:
 * <pre>{@code
 * public class CustomPager<T> implements BiDirectionalPage<T>, Iterable<T> {
 *     private final List<T> items;
 *     private final String nextUrl;
 *     private final String previousUrl;
 *     private final OkHttpClient client;
 *     private final TypeReference<ResponseType<T>> responseType;
 *
 *     public CustomPager(Response<T> response, OkHttpClient client, ...) {
 *         this.items = response.getData();
 *         this.nextUrl = response.getLinks().getNext();
 *         this.previousUrl = response.getLinks().getPrevious();
 *         // ... store other needed context
 *     }
 *
 *     @Override
 *     public boolean hasNext() {
 *         return nextUrl != null;
 *     }
 *
 *     @Override
 *     public CustomPager<T> nextPage() throws IOException {
 *         if (!hasNext()) {
 *             throw new NoSuchElementException("No next page available");
 *         }
 *         // Make HTTP request to nextUrl
 *         // Parse response
 *         // Return new CustomPager instance
 *     }
 *
 *     // ... implement other methods
 * }
 * }</pre>
 *
 * @param <T> The type of items in the page
 */
public class CustomPager<T> implements BiDirectionalPage<T>, Iterable<T> {

    /**
     * Create a CustomPager from an initial response.
     *
     * @param initialResponse The first page response from the API
     * @param client The HTTP client to use for subsequent requests
     * @param requestOptions Request options for authentication, headers, etc.
     * @return A new CustomPager instance
     * @throws IOException if the request fails
     */
    public static <T> CustomPager<T> create(Object initialResponse, okhttp3.OkHttpClient client, Object requestOptions)
            throws IOException {
        throw new UnsupportedOperationException("CustomPager must be implemented. "
                + "Please implement this class in core/CustomPager.java to define your pagination logic. "
                + "This file has been added to .fernignore and will not be overwritten. "
                + "See the class documentation for implementation examples.");
    }

    @Override
    public boolean hasNext() {
        throw new UnsupportedOperationException("CustomPager.hasNext() must be implemented. "
                + "This method should return true if a next page is available.");
    }

    @Override
    public boolean hasPrevious() {
        throw new UnsupportedOperationException("CustomPager.hasPrevious() must be implemented. "
                + "This method should return true if a previous page is available.");
    }

    @Override
    public BiDirectionalPage<T> nextPage() throws IOException {
        throw new UnsupportedOperationException("CustomPager.nextPage() must be implemented. "
                + "This method should fetch and return the next page of results.");
    }

    @Override
    public BiDirectionalPage<T> previousPage() throws IOException {
        throw new UnsupportedOperationException("CustomPager.previousPage() must be implemented. "
                + "This method should fetch and return the previous page of results.");
    }

    @Override
    public List<T> getItems() {
        throw new UnsupportedOperationException("CustomPager.getItems() must be implemented. "
                + "This method should return the items in the current page.");
    }

    @Override
    public <R> Optional<R> getResponse() {
        throw new UnsupportedOperationException("CustomPager.getResponse() must be implemented. "
                + "This method should return the full response object for accessing pagination metadata.");
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException("CustomPager.iterator() must be implemented. "
                + "This method should return an iterator that traverses all items across all pages.");
    }
}
