/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.aicontent;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.aicontent.requests.CreateContentImportSourceRequest;
import com.intercom.api.resources.aicontent.requests.CreateExternalPageRequest;
import com.intercom.api.resources.aicontent.requests.DeleteContentImportSourceRequest;
import com.intercom.api.resources.aicontent.requests.DeleteExternalPageRequest;
import com.intercom.api.resources.aicontent.requests.GetContentImportSourceRequest;
import com.intercom.api.resources.aicontent.requests.GetExternalPageRequest;
import com.intercom.api.resources.aicontent.requests.UpdateContentImportSourceRequest;
import com.intercom.api.resources.aicontent.requests.UpdateExternalPageRequest;
import com.intercom.api.resources.aicontent.types.ContentImportSource;
import com.intercom.api.resources.aicontent.types.ContentImportSourcesList;
import com.intercom.api.resources.aicontent.types.ExternalPage;
import com.intercom.api.resources.aicontent.types.ExternalPagesList;

public class AiContentClient {
    protected final ClientOptions clientOptions;

    private final RawAiContentClient rawClient;

    public AiContentClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawAiContentClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawAiContentClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can retrieve a list of all content import sources for a workspace.
     */
    public ContentImportSourcesList listContentImportSources() {
        return this.rawClient.listContentImportSources().body();
    }

    /**
     * You can retrieve a list of all content import sources for a workspace.
     */
    public ContentImportSourcesList listContentImportSources(RequestOptions requestOptions) {
        return this.rawClient.listContentImportSources(requestOptions).body();
    }

    /**
     * You can create a new content import source by sending a POST request to this endpoint.
     */
    public ContentImportSource createContentImportSource(CreateContentImportSourceRequest request) {
        return this.rawClient.createContentImportSource(request).body();
    }

    /**
     * You can create a new content import source by sending a POST request to this endpoint.
     */
    public ContentImportSource createContentImportSource(
            CreateContentImportSourceRequest request, RequestOptions requestOptions) {
        return this.rawClient.createContentImportSource(request, requestOptions).body();
    }

    public ContentImportSource getContentImportSource(GetContentImportSourceRequest request) {
        return this.rawClient.getContentImportSource(request).body();
    }

    public ContentImportSource getContentImportSource(
            GetContentImportSourceRequest request, RequestOptions requestOptions) {
        return this.rawClient.getContentImportSource(request, requestOptions).body();
    }

    /**
     * You can update an existing content import source.
     */
    public ContentImportSource updateContentImportSource(UpdateContentImportSourceRequest request) {
        return this.rawClient.updateContentImportSource(request).body();
    }

    /**
     * You can update an existing content import source.
     */
    public ContentImportSource updateContentImportSource(
            UpdateContentImportSourceRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateContentImportSource(request, requestOptions).body();
    }

    /**
     * You can delete a content import source by making a DELETE request this endpoint. This will also delete all external pages that were imported from this source.
     */
    public void deleteContentImportSource(DeleteContentImportSourceRequest request) {
        this.rawClient.deleteContentImportSource(request).body();
    }

    /**
     * You can delete a content import source by making a DELETE request this endpoint. This will also delete all external pages that were imported from this source.
     */
    public void deleteContentImportSource(DeleteContentImportSourceRequest request, RequestOptions requestOptions) {
        this.rawClient.deleteContentImportSource(request, requestOptions).body();
    }

    /**
     * You can retrieve a list of all external pages for a workspace.
     */
    public ExternalPagesList listExternalPages() {
        return this.rawClient.listExternalPages().body();
    }

    /**
     * You can retrieve a list of all external pages for a workspace.
     */
    public ExternalPagesList listExternalPages(RequestOptions requestOptions) {
        return this.rawClient.listExternalPages(requestOptions).body();
    }

    /**
     * You can create a new external page by sending a POST request to this endpoint. If an external page already exists with the specified source_id and external_id, it will be updated instead.
     */
    public ExternalPage createExternalPage(CreateExternalPageRequest request) {
        return this.rawClient.createExternalPage(request).body();
    }

    /**
     * You can create a new external page by sending a POST request to this endpoint. If an external page already exists with the specified source_id and external_id, it will be updated instead.
     */
    public ExternalPage createExternalPage(CreateExternalPageRequest request, RequestOptions requestOptions) {
        return this.rawClient.createExternalPage(request, requestOptions).body();
    }

    /**
     * You can retrieve an external page.
     */
    public ExternalPage getExternalPage(GetExternalPageRequest request) {
        return this.rawClient.getExternalPage(request).body();
    }

    /**
     * You can retrieve an external page.
     */
    public ExternalPage getExternalPage(GetExternalPageRequest request, RequestOptions requestOptions) {
        return this.rawClient.getExternalPage(request, requestOptions).body();
    }

    /**
     * You can update an existing external page (if it was created via the API).
     */
    public ExternalPage updateExternalPage(UpdateExternalPageRequest request) {
        return this.rawClient.updateExternalPage(request).body();
    }

    /**
     * You can update an existing external page (if it was created via the API).
     */
    public ExternalPage updateExternalPage(UpdateExternalPageRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateExternalPage(request, requestOptions).body();
    }

    /**
     * Sending a DELETE request for an external page will remove it from the content library UI and from being used for AI answers.
     */
    public ExternalPage deleteExternalPage(DeleteExternalPageRequest request) {
        return this.rawClient.deleteExternalPage(request).body();
    }

    /**
     * Sending a DELETE request for an external page will remove it from the content library UI and from being used for AI answers.
     */
    public ExternalPage deleteExternalPage(DeleteExternalPageRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteExternalPage(request, requestOptions).body();
    }
}
