/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.aicontent.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = DeleteContentImportSourceRequest.Builder.class)
public final class DeleteContentImportSourceRequest {
    private final String sourceId;

    private final Map<String, Object> additionalProperties;

    private DeleteContentImportSourceRequest(String sourceId, Map<String, Object> additionalProperties) {
        this.sourceId = sourceId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the content import source which is given by Intercom.
     */
    @JsonProperty("source_id")
    public String getSourceId() {
        return sourceId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof DeleteContentImportSourceRequest && equalTo((DeleteContentImportSourceRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DeleteContentImportSourceRequest other) {
        return sourceId.equals(other.sourceId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.sourceId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SourceIdStage builder() {
        return new Builder();
    }

    public interface SourceIdStage {
        /**
         * <p>The unique identifier for the content import source which is given by Intercom.</p>
         */
        _FinalStage sourceId(@NotNull String sourceId);

        Builder from(DeleteContentImportSourceRequest other);
    }

    public interface _FinalStage {
        DeleteContentImportSourceRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements SourceIdStage, _FinalStage {
        private String sourceId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(DeleteContentImportSourceRequest other) {
            sourceId(other.getSourceId());
            return this;
        }

        /**
         * <p>The unique identifier for the content import source which is given by Intercom.</p>
         * <p>The unique identifier for the content import source which is given by Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("source_id")
        public _FinalStage sourceId(@NotNull String sourceId) {
            this.sourceId = Objects.requireNonNull(sourceId, "sourceId must not be null");
            return this;
        }

        @java.lang.Override
        public DeleteContentImportSourceRequest build() {
            return new DeleteContentImportSourceRequest(sourceId, additionalProperties);
        }
    }
}
