/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.aicontent.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ContentImportSource.Builder.class)
public final class ContentImportSource {
    private final int id;

    private final int lastSyncedAt;

    private final SyncBehavior syncBehavior;

    private final Status status;

    private final String url;

    private final int createdAt;

    private final int updatedAt;

    private final Map<String, Object> additionalProperties;

    private ContentImportSource(
            int id,
            int lastSyncedAt,
            SyncBehavior syncBehavior,
            Status status,
            String url,
            int createdAt,
            int updatedAt,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.lastSyncedAt = lastSyncedAt;
        this.syncBehavior = syncBehavior;
        this.status = status;
        this.url = url;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Always external_page
     */
    @JsonProperty("type")
    public String getType() {
        return "content_import_source";
    }

    /**
     * @return The unique identifier for the content import source which is given by Intercom.
     */
    @JsonProperty("id")
    public int getId() {
        return id;
    }

    /**
     * @return The time when the content import source was last synced.
     */
    @JsonProperty("last_synced_at")
    public int getLastSyncedAt() {
        return lastSyncedAt;
    }

    /**
     * @return If you intend to create or update External Pages via the API, this should be set to <code>api</code>.
     */
    @JsonProperty("sync_behavior")
    public SyncBehavior getSyncBehavior() {
        return syncBehavior;
    }

    /**
     * @return The status of the content import source.
     */
    @JsonProperty("status")
    public Status getStatus() {
        return status;
    }

    /**
     * @return The URL of the root of the external source.
     */
    @JsonProperty("url")
    public String getUrl() {
        return url;
    }

    /**
     * @return The time when the content import source was created.
     */
    @JsonProperty("created_at")
    public int getCreatedAt() {
        return createdAt;
    }

    /**
     * @return The time when the content import source was last updated.
     */
    @JsonProperty("updated_at")
    public int getUpdatedAt() {
        return updatedAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ContentImportSource && equalTo((ContentImportSource) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContentImportSource other) {
        return id == other.id
                && lastSyncedAt == other.lastSyncedAt
                && syncBehavior.equals(other.syncBehavior)
                && status.equals(other.status)
                && url.equals(other.url)
                && createdAt == other.createdAt
                && updatedAt == other.updatedAt;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.id, this.lastSyncedAt, this.syncBehavior, this.status, this.url, this.createdAt, this.updatedAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * <p>The unique identifier for the content import source which is given by Intercom.</p>
         */
        LastSyncedAtStage id(int id);

        Builder from(ContentImportSource other);
    }

    public interface LastSyncedAtStage {
        /**
         * <p>The time when the content import source was last synced.</p>
         */
        SyncBehaviorStage lastSyncedAt(int lastSyncedAt);
    }

    public interface SyncBehaviorStage {
        /**
         * <p>If you intend to create or update External Pages via the API, this should be set to <code>api</code>.</p>
         */
        StatusStage syncBehavior(@NotNull SyncBehavior syncBehavior);
    }

    public interface StatusStage {
        /**
         * <p>The status of the content import source.</p>
         */
        UrlStage status(@NotNull Status status);
    }

    public interface UrlStage {
        /**
         * <p>The URL of the root of the external source.</p>
         */
        CreatedAtStage url(@NotNull String url);
    }

    public interface CreatedAtStage {
        /**
         * <p>The time when the content import source was created.</p>
         */
        UpdatedAtStage createdAt(int createdAt);
    }

    public interface UpdatedAtStage {
        /**
         * <p>The time when the content import source was last updated.</p>
         */
        _FinalStage updatedAt(int updatedAt);
    }

    public interface _FinalStage {
        ContentImportSource build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements IdStage,
                    LastSyncedAtStage,
                    SyncBehaviorStage,
                    StatusStage,
                    UrlStage,
                    CreatedAtStage,
                    UpdatedAtStage,
                    _FinalStage {
        private int id;

        private int lastSyncedAt;

        private SyncBehavior syncBehavior;

        private Status status;

        private String url;

        private int createdAt;

        private int updatedAt;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ContentImportSource other) {
            id(other.getId());
            lastSyncedAt(other.getLastSyncedAt());
            syncBehavior(other.getSyncBehavior());
            status(other.getStatus());
            url(other.getUrl());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            return this;
        }

        /**
         * <p>The unique identifier for the content import source which is given by Intercom.</p>
         * <p>The unique identifier for the content import source which is given by Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public LastSyncedAtStage id(int id) {
            this.id = id;
            return this;
        }

        /**
         * <p>The time when the content import source was last synced.</p>
         * <p>The time when the content import source was last synced.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("last_synced_at")
        public SyncBehaviorStage lastSyncedAt(int lastSyncedAt) {
            this.lastSyncedAt = lastSyncedAt;
            return this;
        }

        /**
         * <p>If you intend to create or update External Pages via the API, this should be set to <code>api</code>.</p>
         * <p>If you intend to create or update External Pages via the API, this should be set to <code>api</code>.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("sync_behavior")
        public StatusStage syncBehavior(@NotNull SyncBehavior syncBehavior) {
            this.syncBehavior = Objects.requireNonNull(syncBehavior, "syncBehavior must not be null");
            return this;
        }

        /**
         * <p>The status of the content import source.</p>
         * <p>The status of the content import source.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("status")
        public UrlStage status(@NotNull Status status) {
            this.status = Objects.requireNonNull(status, "status must not be null");
            return this;
        }

        /**
         * <p>The URL of the root of the external source.</p>
         * <p>The URL of the root of the external source.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("url")
        public CreatedAtStage url(@NotNull String url) {
            this.url = Objects.requireNonNull(url, "url must not be null");
            return this;
        }

        /**
         * <p>The time when the content import source was created.</p>
         * <p>The time when the content import source was created.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_at")
        public UpdatedAtStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        /**
         * <p>The time when the content import source was last updated.</p>
         * <p>The time when the content import source was last updated.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("updated_at")
        public _FinalStage updatedAt(int updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @java.lang.Override
        public ContentImportSource build() {
            return new ContentImportSource(
                    id, lastSyncedAt, syncBehavior, status, url, createdAt, updatedAt, additionalProperties);
        }
    }

    public static final class Status {
        public static final Status DEACTIVATED = new Status(Value.DEACTIVATED, "deactivated");

        public static final Status ACTIVE = new Status(Value.ACTIVE, "active");

        private final Value value;

        private final String string;

        Status(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof Status && this.string.equals(((Status) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case DEACTIVATED:
                    return visitor.visitDeactivated();
                case ACTIVE:
                    return visitor.visitActive();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static Status valueOf(String value) {
            switch (value) {
                case "deactivated":
                    return DEACTIVATED;
                case "active":
                    return ACTIVE;
                default:
                    return new Status(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            ACTIVE,

            DEACTIVATED,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitActive();

            T visitDeactivated();

            T visitUnknown(String unknownType);
        }
    }

    public static final class SyncBehavior {
        public static final SyncBehavior MANUAL = new SyncBehavior(Value.MANUAL, "manual");

        public static final SyncBehavior API = new SyncBehavior(Value.API, "api");

        public static final SyncBehavior AUTOMATIC = new SyncBehavior(Value.AUTOMATIC, "automatic");

        private final Value value;

        private final String string;

        SyncBehavior(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other)
                    || (other instanceof SyncBehavior && this.string.equals(((SyncBehavior) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case MANUAL:
                    return visitor.visitManual();
                case API:
                    return visitor.visitApi();
                case AUTOMATIC:
                    return visitor.visitAutomatic();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static SyncBehavior valueOf(String value) {
            switch (value) {
                case "manual":
                    return MANUAL;
                case "api":
                    return API;
                case "automatic":
                    return AUTOMATIC;
                default:
                    return new SyncBehavior(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            API,

            AUTOMATIC,

            MANUAL,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitApi();

            T visitAutomatic();

            T visitManual();

            T visitUnknown(String unknownType);
        }
    }
}
