/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.calls.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ListCallsWithTranscriptsRequest.Builder.class)
public final class ListCallsWithTranscriptsRequest {
    private final List<String> conversationIds;

    private final Map<String, Object> additionalProperties;

    private ListCallsWithTranscriptsRequest(List<String> conversationIds, Map<String, Object> additionalProperties) {
        this.conversationIds = conversationIds;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return A list of conversation ids to fetch calls for. Maximum 20.
     */
    @JsonProperty("conversation_ids")
    public List<String> getConversationIds() {
        return conversationIds;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ListCallsWithTranscriptsRequest && equalTo((ListCallsWithTranscriptsRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListCallsWithTranscriptsRequest other) {
        return conversationIds.equals(other.conversationIds);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.conversationIds);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private List<String> conversationIds = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ListCallsWithTranscriptsRequest other) {
            conversationIds(other.getConversationIds());
            return this;
        }

        /**
         * <p>A list of conversation ids to fetch calls for. Maximum 20.</p>
         */
        @JsonSetter(value = "conversation_ids", nulls = Nulls.SKIP)
        public Builder conversationIds(List<String> conversationIds) {
            this.conversationIds.clear();
            if (conversationIds != null) {
                this.conversationIds.addAll(conversationIds);
            }
            return this;
        }

        public Builder addConversationIds(String conversationIds) {
            this.conversationIds.add(conversationIds);
            return this;
        }

        public Builder addAllConversationIds(List<String> conversationIds) {
            if (conversationIds != null) {
                this.conversationIds.addAll(conversationIds);
            }
            return this;
        }

        public ListCallsWithTranscriptsRequest build() {
            return new ListCallsWithTranscriptsRequest(conversationIds, additionalProperties);
        }
    }
}
