/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.conversations.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = AutoAssignConversationRequest.Builder.class)
public final class AutoAssignConversationRequest {
    private final String conversationId;

    private final Map<String, Object> additionalProperties;

    private AutoAssignConversationRequest(String conversationId, Map<String, Object> additionalProperties) {
        this.conversationId = conversationId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The identifier for the conversation as given by Intercom.
     */
    @JsonProperty("conversation_id")
    public String getConversationId() {
        return conversationId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof AutoAssignConversationRequest && equalTo((AutoAssignConversationRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AutoAssignConversationRequest other) {
        return conversationId.equals(other.conversationId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.conversationId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ConversationIdStage builder() {
        return new Builder();
    }

    public interface ConversationIdStage {
        /**
         * <p>The identifier for the conversation as given by Intercom.</p>
         */
        _FinalStage conversationId(@NotNull String conversationId);

        Builder from(AutoAssignConversationRequest other);
    }

    public interface _FinalStage {
        AutoAssignConversationRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements ConversationIdStage, _FinalStage {
        private String conversationId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(AutoAssignConversationRequest other) {
            conversationId(other.getConversationId());
            return this;
        }

        /**
         * <p>The identifier for the conversation as given by Intercom.</p>
         * <p>The identifier for the conversation as given by Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("conversation_id")
        public _FinalStage conversationId(@NotNull String conversationId) {
            this.conversationId = Objects.requireNonNull(conversationId, "conversationId must not be null");
            return this;
        }

        @java.lang.Override
        public AutoAssignConversationRequest build() {
            return new AutoAssignConversationRequest(conversationId, additionalProperties);
        }
    }
}
