/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.customchannelevents;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.customchannelevents.requests.NotifyAttributeCollectedRequest;
import com.intercom.api.resources.customchannelevents.requests.NotifyNewMessageRequest;
import com.intercom.api.resources.customchannelevents.requests.NotifyQuickReplySelectedRequest;
import com.intercom.api.types.CustomChannelBaseEvent;
import com.intercom.api.types.CustomChannelNotificationResponse;

public class CustomChannelEventsClient {
    protected final ClientOptions clientOptions;

    private final RawCustomChannelEventsClient rawClient;

    public CustomChannelEventsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawCustomChannelEventsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawCustomChannelEventsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Notifies Intercom that a new conversation was created in your custom channel/platform. This triggers conversation creation and workflow automations within Intercom for your custom channel integration.
     * <blockquote>
     * <p><strong>Note:</strong> This endpoint is currently under managed availability. Please reach out to your accounts team to discuss access and tailored, hands-on support.</p>
     * </blockquote>
     */
    public CustomChannelNotificationResponse notifyNewConversation(CustomChannelBaseEvent request) {
        return this.rawClient.notifyNewConversation(request).body();
    }

    /**
     * Notifies Intercom that a new conversation was created in your custom channel/platform. This triggers conversation creation and workflow automations within Intercom for your custom channel integration.
     * <blockquote>
     * <p><strong>Note:</strong> This endpoint is currently under managed availability. Please reach out to your accounts team to discuss access and tailored, hands-on support.</p>
     * </blockquote>
     */
    public CustomChannelNotificationResponse notifyNewConversation(
            CustomChannelBaseEvent request, RequestOptions requestOptions) {
        return this.rawClient.notifyNewConversation(request, requestOptions).body();
    }

    /**
     * Notifies Intercom that a new message was sent in a conversation on your custom channel/platform. This allows Intercom to process the message and trigger any relevant workflow automations.
     * <blockquote>
     * <p><strong>Note:</strong> This endpoint is currently under managed availability. Please reach out to your accounts team to discuss access and tailored, hands-on support.</p>
     * </blockquote>
     */
    public CustomChannelNotificationResponse notifyNewMessage(NotifyNewMessageRequest request) {
        return this.rawClient.notifyNewMessage(request).body();
    }

    /**
     * Notifies Intercom that a new message was sent in a conversation on your custom channel/platform. This allows Intercom to process the message and trigger any relevant workflow automations.
     * <blockquote>
     * <p><strong>Note:</strong> This endpoint is currently under managed availability. Please reach out to your accounts team to discuss access and tailored, hands-on support.</p>
     * </blockquote>
     */
    public CustomChannelNotificationResponse notifyNewMessage(
            NotifyNewMessageRequest request, RequestOptions requestOptions) {
        return this.rawClient.notifyNewMessage(request, requestOptions).body();
    }

    /**
     * Notifies Intercom that a user selected a quick reply option in your custom channel/platform. This allows Intercom to process the response and trigger any relevant workflow automations.
     * <blockquote>
     * <p><strong>Note:</strong> This endpoint is currently under managed availability. Please reach out to your accounts team to discuss access and tailored, hands-on support.</p>
     * </blockquote>
     */
    public CustomChannelNotificationResponse notifyQuickReplySelected(NotifyQuickReplySelectedRequest request) {
        return this.rawClient.notifyQuickReplySelected(request).body();
    }

    /**
     * Notifies Intercom that a user selected a quick reply option in your custom channel/platform. This allows Intercom to process the response and trigger any relevant workflow automations.
     * <blockquote>
     * <p><strong>Note:</strong> This endpoint is currently under managed availability. Please reach out to your accounts team to discuss access and tailored, hands-on support.</p>
     * </blockquote>
     */
    public CustomChannelNotificationResponse notifyQuickReplySelected(
            NotifyQuickReplySelectedRequest request, RequestOptions requestOptions) {
        return this.rawClient.notifyQuickReplySelected(request, requestOptions).body();
    }

    /**
     * Notifies Intercom that a user provided a response to an attribute collector in your custom channel/platform. This allows Intercom to process the attribute and trigger any relevant workflow automations.
     * <blockquote>
     * <p><strong>Note:</strong> This endpoint is currently under managed availability. Please reach out to your accounts team to discuss access and tailored, hands-on support.</p>
     * </blockquote>
     */
    public CustomChannelNotificationResponse notifyAttributeCollected(NotifyAttributeCollectedRequest request) {
        return this.rawClient.notifyAttributeCollected(request).body();
    }

    /**
     * Notifies Intercom that a user provided a response to an attribute collector in your custom channel/platform. This allows Intercom to process the attribute and trigger any relevant workflow automations.
     * <blockquote>
     * <p><strong>Note:</strong> This endpoint is currently under managed availability. Please reach out to your accounts team to discuss access and tailored, hands-on support.</p>
     * </blockquote>
     */
    public CustomChannelNotificationResponse notifyAttributeCollected(
            NotifyAttributeCollectedRequest request, RequestOptions requestOptions) {
        return this.rawClient.notifyAttributeCollected(request, requestOptions).body();
    }
}
