/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.helpcenters.collections;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.core.pagination.SyncPagingIterable;
import com.intercom.api.resources.helpcenter.types.Collection;
import com.intercom.api.resources.helpcenters.collections.requests.CreateCollectionRequest;
import com.intercom.api.resources.helpcenters.collections.requests.DeleteCollectionRequest;
import com.intercom.api.resources.helpcenters.collections.requests.FindCollectionRequest;
import com.intercom.api.resources.helpcenters.collections.requests.ListCollectionsRequest;
import com.intercom.api.resources.helpcenters.collections.requests.UpdateCollectionRequest;
import com.intercom.api.types.DeletedCollectionObject;

public class CollectionsClient {
    protected final ClientOptions clientOptions;

    private final RawCollectionsClient rawClient;

    public CollectionsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawCollectionsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawCollectionsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can fetch a list of all collections by making a GET request to <code>https://api.intercom.io/help_center/collections</code>.
     * <p>Collections will be returned in descending order on the <code>updated_at</code> attribute. This means if you need to iterate through results then we'll show the most recently updated collections first.</p>
     */
    public SyncPagingIterable<Collection> list() {
        return this.rawClient.list().body();
    }

    /**
     * You can fetch a list of all collections by making a GET request to <code>https://api.intercom.io/help_center/collections</code>.
     * <p>Collections will be returned in descending order on the <code>updated_at</code> attribute. This means if you need to iterate through results then we'll show the most recently updated collections first.</p>
     */
    public SyncPagingIterable<Collection> list(ListCollectionsRequest request) {
        return this.rawClient.list(request).body();
    }

    /**
     * You can fetch a list of all collections by making a GET request to <code>https://api.intercom.io/help_center/collections</code>.
     * <p>Collections will be returned in descending order on the <code>updated_at</code> attribute. This means if you need to iterate through results then we'll show the most recently updated collections first.</p>
     */
    public SyncPagingIterable<Collection> list(ListCollectionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).body();
    }

    /**
     * You can create a new collection by making a POST request to <code>https://api.intercom.io/help_center/collections.</code>
     */
    public Collection create(CreateCollectionRequest request) {
        return this.rawClient.create(request).body();
    }

    /**
     * You can create a new collection by making a POST request to <code>https://api.intercom.io/help_center/collections.</code>
     */
    public Collection create(CreateCollectionRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).body();
    }

    /**
     * You can fetch the details of a single collection by making a GET request to <code>https://api.intercom.io/help_center/collections/&lt;id&gt;</code>.
     */
    public Collection find(FindCollectionRequest request) {
        return this.rawClient.find(request).body();
    }

    /**
     * You can fetch the details of a single collection by making a GET request to <code>https://api.intercom.io/help_center/collections/&lt;id&gt;</code>.
     */
    public Collection find(FindCollectionRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).body();
    }

    /**
     * You can update the details of a single collection by making a PUT request to <code>https://api.intercom.io/collections/&lt;id&gt;</code>.
     */
    public Collection update(UpdateCollectionRequest request) {
        return this.rawClient.update(request).body();
    }

    /**
     * You can update the details of a single collection by making a PUT request to <code>https://api.intercom.io/collections/&lt;id&gt;</code>.
     */
    public Collection update(UpdateCollectionRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).body();
    }

    /**
     * You can delete a single collection by making a DELETE request to <code>https://api.intercom.io/collections/&lt;id&gt;</code>.
     */
    public DeletedCollectionObject delete(DeleteCollectionRequest request) {
        return this.rawClient.delete(request).body();
    }

    /**
     * You can delete a single collection by making a DELETE request to <code>https://api.intercom.io/collections/&lt;id&gt;</code>.
     */
    public DeletedCollectionObject delete(DeleteCollectionRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).body();
    }
}
