/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.internalarticles.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UpdateInternalArticleRequestBody.Builder.class)
public final class UpdateInternalArticleRequestBody {
    private final int internalArticleId;

    private final Optional<String> title;

    private final Optional<String> body;

    private final Optional<Integer> authorId;

    private final Optional<Integer> ownerId;

    private final Map<String, Object> additionalProperties;

    private UpdateInternalArticleRequestBody(
            int internalArticleId,
            Optional<String> title,
            Optional<String> body,
            Optional<Integer> authorId,
            Optional<Integer> ownerId,
            Map<String, Object> additionalProperties) {
        this.internalArticleId = internalArticleId;
        this.title = title;
        this.body = body;
        this.authorId = authorId;
        this.ownerId = ownerId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the internal article which is given by Intercom.
     */
    @JsonProperty("internal_article_id")
    public int getInternalArticleId() {
        return internalArticleId;
    }

    /**
     * @return The title of the article.
     */
    @JsonProperty("title")
    public Optional<String> getTitle() {
        return title;
    }

    /**
     * @return The content of the article.
     */
    @JsonProperty("body")
    public Optional<String> getBody() {
        return body;
    }

    /**
     * @return The id of the author of the article.
     */
    @JsonProperty("author_id")
    public Optional<Integer> getAuthorId() {
        return authorId;
    }

    /**
     * @return The id of the author of the article.
     */
    @JsonProperty("owner_id")
    public Optional<Integer> getOwnerId() {
        return ownerId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UpdateInternalArticleRequestBody && equalTo((UpdateInternalArticleRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateInternalArticleRequestBody other) {
        return internalArticleId == other.internalArticleId
                && title.equals(other.title)
                && body.equals(other.body)
                && authorId.equals(other.authorId)
                && ownerId.equals(other.ownerId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.internalArticleId, this.title, this.body, this.authorId, this.ownerId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static InternalArticleIdStage builder() {
        return new Builder();
    }

    public interface InternalArticleIdStage {
        /**
         * <p>The unique identifier for the internal article which is given by Intercom.</p>
         */
        _FinalStage internalArticleId(int internalArticleId);

        Builder from(UpdateInternalArticleRequestBody other);
    }

    public interface _FinalStage {
        UpdateInternalArticleRequestBody build();

        /**
         * <p>The title of the article.</p>
         */
        _FinalStage title(Optional<String> title);

        _FinalStage title(String title);

        /**
         * <p>The content of the article.</p>
         */
        _FinalStage body(Optional<String> body);

        _FinalStage body(String body);

        /**
         * <p>The id of the author of the article.</p>
         */
        _FinalStage authorId(Optional<Integer> authorId);

        _FinalStage authorId(Integer authorId);

        /**
         * <p>The id of the author of the article.</p>
         */
        _FinalStage ownerId(Optional<Integer> ownerId);

        _FinalStage ownerId(Integer ownerId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements InternalArticleIdStage, _FinalStage {
        private int internalArticleId;

        private Optional<Integer> ownerId = Optional.empty();

        private Optional<Integer> authorId = Optional.empty();

        private Optional<String> body = Optional.empty();

        private Optional<String> title = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(UpdateInternalArticleRequestBody other) {
            internalArticleId(other.getInternalArticleId());
            title(other.getTitle());
            body(other.getBody());
            authorId(other.getAuthorId());
            ownerId(other.getOwnerId());
            return this;
        }

        /**
         * <p>The unique identifier for the internal article which is given by Intercom.</p>
         * <p>The unique identifier for the internal article which is given by Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("internal_article_id")
        public _FinalStage internalArticleId(int internalArticleId) {
            this.internalArticleId = internalArticleId;
            return this;
        }

        /**
         * <p>The id of the author of the article.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage ownerId(Integer ownerId) {
            this.ownerId = Optional.ofNullable(ownerId);
            return this;
        }

        /**
         * <p>The id of the author of the article.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "owner_id", nulls = Nulls.SKIP)
        public _FinalStage ownerId(Optional<Integer> ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        /**
         * <p>The id of the author of the article.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage authorId(Integer authorId) {
            this.authorId = Optional.ofNullable(authorId);
            return this;
        }

        /**
         * <p>The id of the author of the article.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "author_id", nulls = Nulls.SKIP)
        public _FinalStage authorId(Optional<Integer> authorId) {
            this.authorId = authorId;
            return this;
        }

        /**
         * <p>The content of the article.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        /**
         * <p>The content of the article.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "body", nulls = Nulls.SKIP)
        public _FinalStage body(Optional<String> body) {
            this.body = body;
            return this;
        }

        /**
         * <p>The title of the article.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage title(String title) {
            this.title = Optional.ofNullable(title);
            return this;
        }

        /**
         * <p>The title of the article.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "title", nulls = Nulls.SKIP)
        public _FinalStage title(Optional<String> title) {
            this.title = title;
            return this;
        }

        @java.lang.Override
        public UpdateInternalArticleRequestBody build() {
            return new UpdateInternalArticleRequestBody(
                    internalArticleId, title, body, authorId, ownerId, additionalProperties);
        }
    }
}
