/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.notes;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.core.pagination.SyncPagingIterable;
import com.intercom.api.resources.notes.requests.CreateContactNoteRequest;
import com.intercom.api.resources.notes.requests.FindNoteRequest;
import com.intercom.api.resources.notes.requests.ListContactNotesRequest;
import com.intercom.api.resources.notes.types.Note;

public class NotesClient {
    protected final ClientOptions clientOptions;

    private final RawNotesClient rawClient;

    public NotesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawNotesClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawNotesClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can fetch a list of notes that are associated to a contact.
     */
    public SyncPagingIterable<Note> list(ListContactNotesRequest request) {
        return this.rawClient.list(request).body();
    }

    /**
     * You can fetch a list of notes that are associated to a contact.
     */
    public SyncPagingIterable<Note> list(ListContactNotesRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).body();
    }

    /**
     * You can add a note to a single contact.
     */
    public Note create(CreateContactNoteRequest request) {
        return this.rawClient.create(request).body();
    }

    /**
     * You can add a note to a single contact.
     */
    public Note create(CreateContactNoteRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).body();
    }

    /**
     * You can fetch the details of a single note.
     */
    public Note find(FindNoteRequest request) {
        return this.rawClient.find(request).body();
    }

    /**
     * You can fetch the details of a single note.
     */
    public Note find(FindNoteRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).body();
    }
}
