/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.tags.types;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.CreateOrUpdateTagRequest;
import com.intercom.api.types.TagCompanyRequest;
import com.intercom.api.types.TagMultipleUsersRequest;
import com.intercom.api.types.UntagCompanyRequest;
import java.io.IOException;
import java.util.Objects;

@JsonDeserialize(using = TagsCreateRequestBody.Deserializer.class)
public final class TagsCreateRequestBody {
    private final Object value;

    private final int type;

    private TagsCreateRequestBody(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    @SuppressWarnings("unchecked")
    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((CreateOrUpdateTagRequest) this.value);
        } else if (this.type == 1) {
            return visitor.visit((TagCompanyRequest) this.value);
        } else if (this.type == 2) {
            return visitor.visit((UntagCompanyRequest) this.value);
        } else if (this.type == 3) {
            return visitor.visit((TagMultipleUsersRequest) this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TagsCreateRequestBody && equalTo((TagsCreateRequestBody) other);
    }

    private boolean equalTo(TagsCreateRequestBody other) {
        return value.equals(other.value);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.value);
    }

    @java.lang.Override
    public String toString() {
        return this.value.toString();
    }

    public static TagsCreateRequestBody of(CreateOrUpdateTagRequest value) {
        return new TagsCreateRequestBody(value, 0);
    }

    public static TagsCreateRequestBody of(TagCompanyRequest value) {
        return new TagsCreateRequestBody(value, 1);
    }

    public static TagsCreateRequestBody of(UntagCompanyRequest value) {
        return new TagsCreateRequestBody(value, 2);
    }

    public static TagsCreateRequestBody of(TagMultipleUsersRequest value) {
        return new TagsCreateRequestBody(value, 3);
    }

    public interface Visitor<T> {
        T visit(CreateOrUpdateTagRequest value);

        T visit(TagCompanyRequest value);

        T visit(UntagCompanyRequest value);

        T visit(TagMultipleUsersRequest value);
    }

    static final class Deserializer extends StdDeserializer<TagsCreateRequestBody> {
        Deserializer() {
            super(TagsCreateRequestBody.class);
        }

        @java.lang.Override
        public TagsCreateRequestBody deserialize(JsonParser p, DeserializationContext context) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, CreateOrUpdateTagRequest.class));
            } catch (RuntimeException e) {
            }
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, TagCompanyRequest.class));
            } catch (RuntimeException e) {
            }
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, UntagCompanyRequest.class));
            } catch (RuntimeException e) {
            }
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, TagMultipleUsersRequest.class));
            } catch (RuntimeException e) {
            }
            throw new JsonParseException(p, "Failed to deserialize");
        }
    }
}
