/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.teams;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.teams.requests.FindTeamRequest;
import com.intercom.api.resources.teams.types.Team;
import com.intercom.api.types.TeamList;
import java.util.concurrent.CompletableFuture;

public class AsyncTeamsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawTeamsClient rawClient;

    public AsyncTeamsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTeamsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawTeamsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * This will return a list of team objects for the App.
     */
    public CompletableFuture<TeamList> list() {
        return this.rawClient.list().thenApply(response -> response.body());
    }

    /**
     * This will return a list of team objects for the App.
     */
    public CompletableFuture<TeamList> list(RequestOptions requestOptions) {
        return this.rawClient.list(requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of a single team, containing an array of admins that belong to this team.
     */
    public CompletableFuture<Team> find(FindTeamRequest request) {
        return this.rawClient.find(request).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of a single team, containing an array of admins that belong to this team.
     */
    public CompletableFuture<Team> find(FindTeamRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).thenApply(response -> response.body());
    }
}
