/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.teams;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.teams.requests.FindTeamRequest;
import com.intercom.api.resources.teams.types.Team;
import com.intercom.api.types.TeamList;

public class TeamsClient {
    protected final ClientOptions clientOptions;

    private final RawTeamsClient rawClient;

    public TeamsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawTeamsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawTeamsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * This will return a list of team objects for the App.
     */
    public TeamList list() {
        return this.rawClient.list().body();
    }

    /**
     * This will return a list of team objects for the App.
     */
    public TeamList list(RequestOptions requestOptions) {
        return this.rawClient.list(requestOptions).body();
    }

    /**
     * You can fetch the details of a single team, containing an array of admins that belong to this team.
     */
    public Team find(FindTeamRequest request) {
        return this.rawClient.find(request).body();
    }

    /**
     * You can fetch the details of a single team, containing an array of admins that belong to this team.
     */
    public Team find(FindTeamRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).body();
    }
}
