/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.ticketstates;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.types.TicketStateList;
import java.util.concurrent.CompletableFuture;

public class AsyncTicketStatesClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawTicketStatesClient rawClient;

    public AsyncTicketStatesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTicketStatesClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawTicketStatesClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can get a list of all ticket states for a workspace.
     */
    public CompletableFuture<TicketStateList> listTicketStates() {
        return this.rawClient.listTicketStates().thenApply(response -> response.body());
    }

    /**
     * You can get a list of all ticket states for a workspace.
     */
    public CompletableFuture<TicketStateList> listTicketStates(RequestOptions requestOptions) {
        return this.rawClient.listTicketStates(requestOptions).thenApply(response -> response.body());
    }
}
