/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.tickettypes;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.core.Suppliers;
import com.intercom.api.resources.tickets.types.TicketType;
import com.intercom.api.resources.tickettypes.attributes.AttributesClient;
import com.intercom.api.resources.tickettypes.requests.FindTicketTypeRequest;
import com.intercom.api.resources.tickettypes.requests.UpdateTicketTypeRequest;
import com.intercom.api.types.CreateTicketTypeRequest;
import com.intercom.api.types.TicketTypeList;
import java.util.Optional;
import java.util.function.Supplier;

public class TicketTypesClient {
    protected final ClientOptions clientOptions;

    private final RawTicketTypesClient rawClient;

    protected final Supplier<AttributesClient> attributesClient;

    public TicketTypesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawTicketTypesClient(clientOptions);
        this.attributesClient = Suppliers.memoize(() -> new AttributesClient(clientOptions));
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawTicketTypesClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can get a list of all ticket types for a workspace.
     */
    public TicketTypeList list() {
        return this.rawClient.list().body();
    }

    /**
     * You can get a list of all ticket types for a workspace.
     */
    public TicketTypeList list(RequestOptions requestOptions) {
        return this.rawClient.list(requestOptions).body();
    }

    /**
     * You can create a new ticket type.
     * <blockquote>
     * <p>📘 Creating ticket types.</p>
     * <p>Every ticket type will be created with two default attributes: <em>default_title</em> and <em>default_description</em>.
     * For the <code>icon</code> propery, use an emoji from <a href="https://twemoji-cheatsheet.vercel.app/">Twemoji Cheatsheet</a></p>
     * </blockquote>
     */
    public Optional<TicketType> create() {
        return this.rawClient.create().body();
    }

    /**
     * You can create a new ticket type.
     * <blockquote>
     * <p>📘 Creating ticket types.</p>
     * <p>Every ticket type will be created with two default attributes: <em>default_title</em> and <em>default_description</em>.
     * For the <code>icon</code> propery, use an emoji from <a href="https://twemoji-cheatsheet.vercel.app/">Twemoji Cheatsheet</a></p>
     * </blockquote>
     */
    public Optional<TicketType> create(Optional<CreateTicketTypeRequest> request) {
        return this.rawClient.create(request).body();
    }

    /**
     * You can create a new ticket type.
     * <blockquote>
     * <p>📘 Creating ticket types.</p>
     * <p>Every ticket type will be created with two default attributes: <em>default_title</em> and <em>default_description</em>.
     * For the <code>icon</code> propery, use an emoji from <a href="https://twemoji-cheatsheet.vercel.app/">Twemoji Cheatsheet</a></p>
     * </blockquote>
     */
    public Optional<TicketType> create(Optional<CreateTicketTypeRequest> request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).body();
    }

    /**
     * You can fetch the details of a single ticket type.
     */
    public Optional<TicketType> get(FindTicketTypeRequest request) {
        return this.rawClient.get(request).body();
    }

    /**
     * You can fetch the details of a single ticket type.
     */
    public Optional<TicketType> get(FindTicketTypeRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).body();
    }

    /**
     * You can update a ticket type.
     * <blockquote>
     * <p>📘 Updating a ticket type.</p>
     * <p>For the <code>icon</code> propery, use an emoji from <a href="https://twemoji-cheatsheet.vercel.app/">Twemoji Cheatsheet</a></p>
     * </blockquote>
     */
    public Optional<TicketType> update(UpdateTicketTypeRequest request) {
        return this.rawClient.update(request).body();
    }

    /**
     * You can update a ticket type.
     * <blockquote>
     * <p>📘 Updating a ticket type.</p>
     * <p>For the <code>icon</code> propery, use an emoji from <a href="https://twemoji-cheatsheet.vercel.app/">Twemoji Cheatsheet</a></p>
     * </blockquote>
     */
    public Optional<TicketType> update(UpdateTicketTypeRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).body();
    }

    public AttributesClient attributes() {
        return this.attributesClient.get();
    }
}
