/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.aicontent;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.aicontent.requests.CreateContentImportSourceRequest;
import com.intercom.api.resources.unstable.aicontent.requests.CreateExternalPageRequest;
import com.intercom.api.resources.unstable.aicontent.requests.DeleteContentImportSourceRequest;
import com.intercom.api.resources.unstable.aicontent.requests.DeleteExternalPageRequest;
import com.intercom.api.resources.unstable.aicontent.requests.GetContentImportSourceRequest;
import com.intercom.api.resources.unstable.aicontent.requests.GetExternalPageRequest;
import com.intercom.api.resources.unstable.aicontent.requests.UpdateContentImportSourceRequest;
import com.intercom.api.resources.unstable.aicontent.requests.UpdateExternalPageRequest;
import com.intercom.api.resources.unstable.aicontent.types.ContentImportSource;
import com.intercom.api.resources.unstable.aicontent.types.ContentImportSourcesList;
import com.intercom.api.resources.unstable.aicontent.types.ExternalPage;
import com.intercom.api.resources.unstable.aicontent.types.ExternalPagesList;
import java.util.concurrent.CompletableFuture;

public class AsyncAiContentClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawAiContentClient rawClient;

    public AsyncAiContentClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawAiContentClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawAiContentClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can retrieve a list of all content import sources for a workspace.
     */
    public CompletableFuture<ContentImportSourcesList> listContentImportSources() {
        return this.rawClient.listContentImportSources().thenApply(response -> response.body());
    }

    /**
     * You can retrieve a list of all content import sources for a workspace.
     */
    public CompletableFuture<ContentImportSourcesList> listContentImportSources(RequestOptions requestOptions) {
        return this.rawClient.listContentImportSources(requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can create a new content import source by sending a POST request to this endpoint.
     */
    public CompletableFuture<ContentImportSource> createContentImportSource(CreateContentImportSourceRequest request) {
        return this.rawClient.createContentImportSource(request).thenApply(response -> response.body());
    }

    /**
     * You can create a new content import source by sending a POST request to this endpoint.
     */
    public CompletableFuture<ContentImportSource> createContentImportSource(
            CreateContentImportSourceRequest request, RequestOptions requestOptions) {
        return this.rawClient.createContentImportSource(request, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<ContentImportSource> getContentImportSource(GetContentImportSourceRequest request) {
        return this.rawClient.getContentImportSource(request).thenApply(response -> response.body());
    }

    public CompletableFuture<ContentImportSource> getContentImportSource(
            GetContentImportSourceRequest request, RequestOptions requestOptions) {
        return this.rawClient.getContentImportSource(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can update an existing content import source.
     */
    public CompletableFuture<ContentImportSource> updateContentImportSource(UpdateContentImportSourceRequest request) {
        return this.rawClient.updateContentImportSource(request).thenApply(response -> response.body());
    }

    /**
     * You can update an existing content import source.
     */
    public CompletableFuture<ContentImportSource> updateContentImportSource(
            UpdateContentImportSourceRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateContentImportSource(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can delete a content import source by making a DELETE request this endpoint. This will also delete all external pages that were imported from this source.
     */
    public CompletableFuture<Void> deleteContentImportSource(DeleteContentImportSourceRequest request) {
        return this.rawClient.deleteContentImportSource(request).thenApply(response -> response.body());
    }

    /**
     * You can delete a content import source by making a DELETE request this endpoint. This will also delete all external pages that were imported from this source.
     */
    public CompletableFuture<Void> deleteContentImportSource(
            DeleteContentImportSourceRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteContentImportSource(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can retrieve a list of all external pages for a workspace.
     */
    public CompletableFuture<ExternalPagesList> listExternalPages() {
        return this.rawClient.listExternalPages().thenApply(response -> response.body());
    }

    /**
     * You can retrieve a list of all external pages for a workspace.
     */
    public CompletableFuture<ExternalPagesList> listExternalPages(RequestOptions requestOptions) {
        return this.rawClient.listExternalPages(requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can create a new external page by sending a POST request to this endpoint. If an external page already exists with the specified source_id and external_id, it will be updated instead.
     */
    public CompletableFuture<ExternalPage> createExternalPage(CreateExternalPageRequest request) {
        return this.rawClient.createExternalPage(request).thenApply(response -> response.body());
    }

    /**
     * You can create a new external page by sending a POST request to this endpoint. If an external page already exists with the specified source_id and external_id, it will be updated instead.
     */
    public CompletableFuture<ExternalPage> createExternalPage(
            CreateExternalPageRequest request, RequestOptions requestOptions) {
        return this.rawClient.createExternalPage(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can retrieve an external page.
     */
    public CompletableFuture<ExternalPage> getExternalPage(GetExternalPageRequest request) {
        return this.rawClient.getExternalPage(request).thenApply(response -> response.body());
    }

    /**
     * You can retrieve an external page.
     */
    public CompletableFuture<ExternalPage> getExternalPage(
            GetExternalPageRequest request, RequestOptions requestOptions) {
        return this.rawClient.getExternalPage(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can update an existing external page (if it was created via the API).
     */
    public CompletableFuture<ExternalPage> updateExternalPage(UpdateExternalPageRequest request) {
        return this.rawClient.updateExternalPage(request).thenApply(response -> response.body());
    }

    /**
     * You can update an existing external page (if it was created via the API).
     */
    public CompletableFuture<ExternalPage> updateExternalPage(
            UpdateExternalPageRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateExternalPage(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Sending a DELETE request for an external page will remove it from the content library UI and from being used for AI answers.
     */
    public CompletableFuture<ExternalPage> deleteExternalPage(DeleteExternalPageRequest request) {
        return this.rawClient.deleteExternalPage(request).thenApply(response -> response.body());
    }

    /**
     * Sending a DELETE request for an external page will remove it from the content library UI and from being used for AI answers.
     */
    public CompletableFuture<ExternalPage> deleteExternalPage(
            DeleteExternalPageRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteExternalPage(request, requestOptions).thenApply(response -> response.body());
    }
}
