/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.calls;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.calls.requests.CollectFinVoiceCallByExternalIdRequest;
import com.intercom.api.resources.unstable.calls.requests.CollectFinVoiceCallByIdRequest;
import com.intercom.api.resources.unstable.calls.requests.CollectFinVoiceCallByPhoneNumberRequest;
import com.intercom.api.resources.unstable.calls.requests.ListCallsRequest;
import com.intercom.api.resources.unstable.calls.requests.ListCallsWithTranscriptsRequest;
import com.intercom.api.resources.unstable.calls.requests.ShowCallRecordingRequest;
import com.intercom.api.resources.unstable.calls.requests.ShowCallRequest;
import com.intercom.api.resources.unstable.calls.requests.ShowCallTranscriptRequest;
import com.intercom.api.resources.unstable.calls.types.Call;
import com.intercom.api.resources.unstable.calls.types.ListCallsWithTranscriptsResponse;
import com.intercom.api.resources.unstable.types.AiCallResponse;
import com.intercom.api.resources.unstable.types.CallList;
import com.intercom.api.resources.unstable.types.Error;
import com.intercom.api.resources.unstable.types.RegisterFinVoiceCallRequest;
import java.util.Optional;

public class CallsClient {
    protected final ClientOptions clientOptions;

    private final RawCallsClient rawClient;

    public CallsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawCallsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawCallsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieve a paginated list of calls.
     */
    public CallList listCalls() {
        return this.rawClient.listCalls().body();
    }

    /**
     * Retrieve a paginated list of calls.
     */
    public CallList listCalls(ListCallsRequest request) {
        return this.rawClient.listCalls(request).body();
    }

    /**
     * Retrieve a paginated list of calls.
     */
    public CallList listCalls(ListCallsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCalls(request, requestOptions).body();
    }

    /**
     * Retrieve a single call by id.
     */
    public Call showCall(ShowCallRequest request) {
        return this.rawClient.showCall(request).body();
    }

    /**
     * Retrieve a single call by id.
     */
    public Call showCall(ShowCallRequest request, RequestOptions requestOptions) {
        return this.rawClient.showCall(request, requestOptions).body();
    }

    /**
     * Redirects to a signed URL for the call's recording if it exists.
     */
    public void showCallRecording(ShowCallRecordingRequest request) {
        this.rawClient.showCallRecording(request).body();
    }

    /**
     * Redirects to a signed URL for the call's recording if it exists.
     */
    public void showCallRecording(ShowCallRecordingRequest request, RequestOptions requestOptions) {
        this.rawClient.showCallRecording(request, requestOptions).body();
    }

    /**
     * Returns the transcript for the specified call as a downloadable text file.
     */
    public String showCallTranscript(ShowCallTranscriptRequest request) {
        return this.rawClient.showCallTranscript(request).body();
    }

    /**
     * Returns the transcript for the specified call as a downloadable text file.
     */
    public String showCallTranscript(ShowCallTranscriptRequest request, RequestOptions requestOptions) {
        return this.rawClient.showCallTranscript(request, requestOptions).body();
    }

    /**
     * Retrieve calls by a list of conversation ids and include transcripts when available.
     * A maximum of 20 <code>conversation_ids</code> can be provided. If none are provided or more than 20 are provided, a 400 error is returned.
     */
    public ListCallsWithTranscriptsResponse listCallsWithTranscripts(ListCallsWithTranscriptsRequest request) {
        return this.rawClient.listCallsWithTranscripts(request).body();
    }

    /**
     * Retrieve calls by a list of conversation ids and include transcripts when available.
     * A maximum of 20 <code>conversation_ids</code> can be provided. If none are provided or more than 20 are provided, a 400 error is returned.
     */
    public ListCallsWithTranscriptsResponse listCallsWithTranscripts(
            ListCallsWithTranscriptsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCallsWithTranscripts(request, requestOptions).body();
    }

    /**
     * Register a Fin Voice call with Intercom. This endpoint creates an external reference
     * that links an external call identifier to an Intercom call and conversation.
     * <p>The call can be from different sources:</p>
     * <ul>
     * <li>AWS Connect (default)</li>
     * <li>Five9</li>
     * <li>Zoom Phone</li>
     * </ul>
     */
    public AiCallResponse registerFinVoiceCall() {
        return this.rawClient.registerFinVoiceCall().body();
    }

    /**
     * Register a Fin Voice call with Intercom. This endpoint creates an external reference
     * that links an external call identifier to an Intercom call and conversation.
     * <p>The call can be from different sources:</p>
     * <ul>
     * <li>AWS Connect (default)</li>
     * <li>Five9</li>
     * <li>Zoom Phone</li>
     * </ul>
     */
    public AiCallResponse registerFinVoiceCall(Optional<RegisterFinVoiceCallRequest> request) {
        return this.rawClient.registerFinVoiceCall(request).body();
    }

    /**
     * Register a Fin Voice call with Intercom. This endpoint creates an external reference
     * that links an external call identifier to an Intercom call and conversation.
     * <p>The call can be from different sources:</p>
     * <ul>
     * <li>AWS Connect (default)</li>
     * <li>Five9</li>
     * <li>Zoom Phone</li>
     * </ul>
     */
    public AiCallResponse registerFinVoiceCall(
            Optional<RegisterFinVoiceCallRequest> request, RequestOptions requestOptions) {
        return this.rawClient.registerFinVoiceCall(request, requestOptions).body();
    }

    /**
     * Retrieve information about a Fin Voice call using the external reference ID.
     */
    public AiCallResponse collectFinVoiceCallById(CollectFinVoiceCallByIdRequest request) {
        return this.rawClient.collectFinVoiceCallById(request).body();
    }

    /**
     * Retrieve information about a Fin Voice call using the external reference ID.
     */
    public AiCallResponse collectFinVoiceCallById(
            CollectFinVoiceCallByIdRequest request, RequestOptions requestOptions) {
        return this.rawClient.collectFinVoiceCallById(request, requestOptions).body();
    }

    /**
     * Retrieve information about a Fin Voice call using the external call identifier.
     */
    public AiCallResponse collectFinVoiceCallByExternalId(CollectFinVoiceCallByExternalIdRequest request) {
        return this.rawClient.collectFinVoiceCallByExternalId(request).body();
    }

    /**
     * Retrieve information about a Fin Voice call using the external call identifier.
     */
    public AiCallResponse collectFinVoiceCallByExternalId(
            CollectFinVoiceCallByExternalIdRequest request, RequestOptions requestOptions) {
        return this.rawClient
                .collectFinVoiceCallByExternalId(request, requestOptions)
                .body();
    }

    /**
     * Retrieve information about a Fin Voice call using the phone number.
     * <p>Returns the most recent matched call for the given phone number, ordered by creation date.</p>
     */
    public Error collectFinVoiceCallByPhoneNumber(CollectFinVoiceCallByPhoneNumberRequest request) {
        return this.rawClient.collectFinVoiceCallByPhoneNumber(request).body();
    }

    /**
     * Retrieve information about a Fin Voice call using the phone number.
     * <p>Returns the most recent matched call for the given phone number, ordered by creation date.</p>
     */
    public Error collectFinVoiceCallByPhoneNumber(
            CollectFinVoiceCallByPhoneNumberRequest request, RequestOptions requestOptions) {
        return this.rawClient
                .collectFinVoiceCallByPhoneNumber(request, requestOptions)
                .body();
    }
}
