/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.contacts;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.contacts.requests.ArchiveContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.BlockContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.DeleteContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.ListCompaniesForAContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.ListSegmentsForAContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.ListSubscriptionsForAContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.ListTagsForAContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.MergeContactsRequest;
import com.intercom.api.resources.unstable.contacts.requests.ShowContactByExternalIdRequest;
import com.intercom.api.resources.unstable.contacts.requests.ShowContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.UnarchiveContactRequest;
import com.intercom.api.resources.unstable.contacts.requests.UpdateContactRequest;
import com.intercom.api.resources.unstable.contacts.types.CreateContactResponse;
import com.intercom.api.resources.unstable.contacts.types.MergeContactResponse;
import com.intercom.api.resources.unstable.contacts.types.ShowContactByExternalIdResponse;
import com.intercom.api.resources.unstable.contacts.types.ShowContactResponse;
import com.intercom.api.resources.unstable.contacts.types.UpdateContactResponse;
import com.intercom.api.resources.unstable.types.ContactArchived;
import com.intercom.api.resources.unstable.types.ContactAttachedCompanies;
import com.intercom.api.resources.unstable.types.ContactBlocked;
import com.intercom.api.resources.unstable.types.ContactDeleted;
import com.intercom.api.resources.unstable.types.ContactList;
import com.intercom.api.resources.unstable.types.ContactSegments;
import com.intercom.api.resources.unstable.types.ContactUnarchived;
import com.intercom.api.resources.unstable.types.SearchRequest;
import com.intercom.api.resources.unstable.types.SubscriptionTypeList;
import com.intercom.api.resources.unstable.types.TagList;
import java.util.concurrent.CompletableFuture;

public class AsyncContactsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawContactsClient rawClient;

    public AsyncContactsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawContactsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawContactsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can fetch a list of companies that are associated to a contact.
     */
    public CompletableFuture<ContactAttachedCompanies> listCompaniesForAContact(
            ListCompaniesForAContactRequest request) {
        return this.rawClient.listCompaniesForAContact(request).thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of companies that are associated to a contact.
     */
    public CompletableFuture<ContactAttachedCompanies> listCompaniesForAContact(
            ListCompaniesForAContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.listCompaniesForAContact(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of segments that are associated to a contact.
     */
    public CompletableFuture<ContactSegments> listSegmentsForAContact(ListSegmentsForAContactRequest request) {
        return this.rawClient.listSegmentsForAContact(request).thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of segments that are associated to a contact.
     */
    public CompletableFuture<ContactSegments> listSegmentsForAContact(
            ListSegmentsForAContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.listSegmentsForAContact(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of subscription types that are attached to a contact. These can be subscriptions that a user has 'opted-in' to or has 'opted-out' from, depending on the subscription type.
     * This will return a list of Subscription Type objects that the contact is associated with.
     * <p>The data property will show a combined list of:</p>
     * <p>1.Opt-out subscription types that the user has opted-out from.
     * 2.Opt-in subscription types that the user has opted-in to receiving.</p>
     */
    public CompletableFuture<SubscriptionTypeList> listSubscriptionsForAContact(
            ListSubscriptionsForAContactRequest request) {
        return this.rawClient.listSubscriptionsForAContact(request).thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of subscription types that are attached to a contact. These can be subscriptions that a user has 'opted-in' to or has 'opted-out' from, depending on the subscription type.
     * This will return a list of Subscription Type objects that the contact is associated with.
     * <p>The data property will show a combined list of:</p>
     * <p>1.Opt-out subscription types that the user has opted-out from.
     * 2.Opt-in subscription types that the user has opted-in to receiving.</p>
     */
    public CompletableFuture<SubscriptionTypeList> listSubscriptionsForAContact(
            ListSubscriptionsForAContactRequest request, RequestOptions requestOptions) {
        return this.rawClient
                .listSubscriptionsForAContact(request, requestOptions)
                .thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of all tags that are attached to a specific contact.
     */
    public CompletableFuture<TagList> listTagsForAContact(ListTagsForAContactRequest request) {
        return this.rawClient.listTagsForAContact(request).thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of all tags that are attached to a specific contact.
     */
    public CompletableFuture<TagList> listTagsForAContact(
            ListTagsForAContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.listTagsForAContact(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of a single contact.
     */
    public CompletableFuture<ShowContactResponse> showContact(ShowContactRequest request) {
        return this.rawClient.showContact(request).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of a single contact.
     */
    public CompletableFuture<ShowContactResponse> showContact(
            ShowContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.showContact(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can update an existing contact (ie. user or lead).
     * <p>{% admonition type=&quot;info&quot; %}
     * This endpoint handles both <strong>contact updates</strong> and <strong>custom object associations</strong>.</p>
     * <p>See <em><code>update a contact with an association to a custom object instance</code></em> in the request/response examples to see the custom object association format.
     * {% /admonition %}</p>
     */
    public CompletableFuture<UpdateContactResponse> updateContact(UpdateContactRequest request) {
        return this.rawClient.updateContact(request).thenApply(response -> response.body());
    }

    /**
     * You can update an existing contact (ie. user or lead).
     * <p>{% admonition type=&quot;info&quot; %}
     * This endpoint handles both <strong>contact updates</strong> and <strong>custom object associations</strong>.</p>
     * <p>See <em><code>update a contact with an association to a custom object instance</code></em> in the request/response examples to see the custom object association format.
     * {% /admonition %}</p>
     */
    public CompletableFuture<UpdateContactResponse> updateContact(
            UpdateContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateContact(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can delete a single contact.
     */
    public CompletableFuture<ContactDeleted> deleteContact(DeleteContactRequest request) {
        return this.rawClient.deleteContact(request).thenApply(response -> response.body());
    }

    /**
     * You can delete a single contact.
     */
    public CompletableFuture<ContactDeleted> deleteContact(
            DeleteContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteContact(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can merge a contact with a <code>role</code> of <code>lead</code> into a contact with a <code>role</code> of <code>user</code>.
     */
    public CompletableFuture<MergeContactResponse> mergeContact() {
        return this.rawClient.mergeContact().thenApply(response -> response.body());
    }

    /**
     * You can merge a contact with a <code>role</code> of <code>lead</code> into a contact with a <code>role</code> of <code>user</code>.
     */
    public CompletableFuture<MergeContactResponse> mergeContact(MergeContactsRequest request) {
        return this.rawClient.mergeContact(request).thenApply(response -> response.body());
    }

    /**
     * You can merge a contact with a <code>role</code> of <code>lead</code> into a contact with a <code>role</code> of <code>user</code>.
     */
    public CompletableFuture<MergeContactResponse> mergeContact(
            MergeContactsRequest request, RequestOptions requestOptions) {
        return this.rawClient.mergeContact(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can search for multiple contacts by the value of their attributes in order to fetch exactly who you want.
     * <p>To search for contacts, you need to send a <code>POST</code> request to <code>https://api.intercom.io/contacts/search</code>.</p>
     * <p>This will accept a query object in the body which will define your filters in order to search for contacts.</p>
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Optimizing search queries&quot; %}
     * Search queries can be complex, so optimizing them can help the performance of your search.
     * Use the <code>AND</code> and <code>OR</code> operators to combine multiple filters to get the exact results you need and utilize
     * pagination to limit the number of results returned. The default is <code>50</code> results per page.
     * See the <a href="https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#example-search-conversations-request">pagination section</a> for more details on how to use the <code>starting_after</code> param.
     * {% /admonition %}</p>
     * <h3>Contact Creation Delay</h3>
     * <p>If a contact has recently been created, there is a possibility that it will not yet be available when searching. This means that it may not appear in the response. This delay can take a few minutes. If you need to be instantly notified it is recommended to use webhooks and iterate to see if they match your search filters.</p>
     * <h3>Nesting &amp; Limitations</h3>
     * <p>You can nest these filters in order to get even more granular insights that pinpoint exactly what you need. Example: (1 OR 2) AND (3 OR 4).
     * There are some limitations to the amount of multiple's there can be:</p>
     * <ul>
     * <li>There's a limit of max 2 nested filters</li>
     * <li>There's a limit of max 15 filters for each AND or OR group</li>
     * </ul>
     * <h3>Searching for Timestamp Fields</h3>
     * <p>All timestamp fields (created_at, updated_at etc.) are indexed as Dates for Contact Search queries; Datetime queries are not currently supported. This means you can only query for timestamp fields by day - not hour, minute or second.
     * For example, if you search for all Contacts with a created_at value greater (&gt;) than 1577869200 (the UNIX timestamp for January 1st, 2020 9:00 AM), that will be interpreted as 1577836800 (January 1st, 2020 12:00 AM). The search results will then include Contacts created from January 2nd, 2020 12:00 AM onwards.
     * If you'd like to get contacts created on January 1st, 2020 you should search with a created_at value equal (=) to 1577836800 (January 1st, 2020 12:00 AM).
     * This behaviour applies only to timestamps used in search queries. The search results will still contain the full UNIX timestamp and be sorted accordingly.</p>
     * <h3>Accepted Fields</h3>
     * <p>Most key listed as part of the Contacts Model are searchable, whether writeable or not. The value you search for has to match the accepted type, otherwise the query will fail (ie. as <code>created_at</code> accepts a date, the <code>value</code> cannot be a string such as <code>&quot;foorbar&quot;</code>).</p>
     * <p>| Field                              | Type                           |
     * | ---------------------------------- | ------------------------------ |
     * | id                                 | String                         |
     * | role                               | String&lt;br&gt;Accepts user or lead |
     * | name                               | String                         |
     * | avatar                             | String                         |
     * | owner_id                           | Integer                        |
     * | email                              | String                         |
     * | email_domain                       | String                         |
     * | phone                              | String                         |
     * | formatted_phone                    | String                         |
     * | external_id                        | String                         |
     * | created_at                         | Date (UNIX Timestamp)          |
     * | signed_up_at                       | Date (UNIX Timestamp)          |
     * | updated_at                         | Date (UNIX Timestamp)          |
     * | last_seen_at                       | Date (UNIX Timestamp)          |
     * | last_contacted_at                  | Date (UNIX Timestamp)          |
     * | last_replied_at                    | Date (UNIX Timestamp)          |
     * | last_email_opened_at               | Date (UNIX Timestamp)          |
     * | last_email_clicked_at              | Date (UNIX Timestamp)          |
     * | language_override                  | String                         |
     * | browser                            | String                         |
     * | browser_language                   | String                         |
     * | os                                 | String                         |
     * | location.country                   | String                         |
     * | location.region                    | String                         |
     * | location.city                      | String                         |
     * | unsubscribed_from_emails           | Boolean                        |
     * | marked_email_as_spam               | Boolean                        |
     * | has_hard_bounced                   | Boolean                        |
     * | ios_last_seen_at                   | Date (UNIX Timestamp)          |
     * | ios_app_version                    | String                         |
     * | ios_device                         | String                         |
     * | ios_app_device                     | String                         |
     * | ios_os_version                     | String                         |
     * | ios_app_name                       | String                         |
     * | ios_sdk_version                    | String                         |
     * | android_last_seen_at               | Date (UNIX Timestamp)          |
     * | android_app_version                | String                         |
     * | android_device                     | String                         |
     * | android_app_name                   | String                         |
     * | andoid_sdk_version                 | String                         |
     * | segment_id                         | String                         |
     * | tag_id                             | String                         |
     * | custom_attributes.{attribute_name} | String                         |</p>
     * <h3>Accepted Operators</h3>
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Searching based on <code>created_at</code>&quot; %}
     * You cannot use the <code>&lt;=</code> or <code>&gt;=</code> operators to search by <code>created_at</code>.
     * {% /admonition %}</p>
     * <p>The table below shows the operators you can use to define how you want to search for the value.  The operator should be put in as a string (<code>&quot;=&quot;</code>). The operator has to be compatible with the field's type (eg. you cannot search with <code>&gt;</code> for a given string value as it's only compatible for integer's and dates).</p>
     * <p>| Operator | Valid Types                      | Description                                                      |
     * | :------- | :------------------------------- | :--------------------------------------------------------------- |
     * | =        | All                              | Equals                                                           |
     * | !=       | All                              | Doesn't Equal                                                    |
     * | IN       | All                              | In&lt;br&gt;Shortcut for <code>OR</code> queries&lt;br&gt;Values must be in Array       |
     * | NIN      | All                              | Not In&lt;br&gt;Shortcut for <code>OR !</code> queries&lt;br&gt;Values must be in Array |
     * | &gt;        | Integer&lt;br&gt;Date (UNIX Timestamp) | Greater than                                                     |
     * | &lt;       | Integer&lt;br&gt;Date (UNIX Timestamp) | Lower than                                                       |
     * | ~        | String                           | Contains                                                         |
     * | !~       | String                           | Doesn't Contain                                                  |
     * | ^        | String                           | Starts With                                                      |
     * | $        | String                           | Ends With                                                        |</p>
     */
    public CompletableFuture<ContactList> searchContacts(SearchRequest request) {
        return this.rawClient.searchContacts(request).thenApply(response -> response.body());
    }

    /**
     * You can search for multiple contacts by the value of their attributes in order to fetch exactly who you want.
     * <p>To search for contacts, you need to send a <code>POST</code> request to <code>https://api.intercom.io/contacts/search</code>.</p>
     * <p>This will accept a query object in the body which will define your filters in order to search for contacts.</p>
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Optimizing search queries&quot; %}
     * Search queries can be complex, so optimizing them can help the performance of your search.
     * Use the <code>AND</code> and <code>OR</code> operators to combine multiple filters to get the exact results you need and utilize
     * pagination to limit the number of results returned. The default is <code>50</code> results per page.
     * See the <a href="https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#example-search-conversations-request">pagination section</a> for more details on how to use the <code>starting_after</code> param.
     * {% /admonition %}</p>
     * <h3>Contact Creation Delay</h3>
     * <p>If a contact has recently been created, there is a possibility that it will not yet be available when searching. This means that it may not appear in the response. This delay can take a few minutes. If you need to be instantly notified it is recommended to use webhooks and iterate to see if they match your search filters.</p>
     * <h3>Nesting &amp; Limitations</h3>
     * <p>You can nest these filters in order to get even more granular insights that pinpoint exactly what you need. Example: (1 OR 2) AND (3 OR 4).
     * There are some limitations to the amount of multiple's there can be:</p>
     * <ul>
     * <li>There's a limit of max 2 nested filters</li>
     * <li>There's a limit of max 15 filters for each AND or OR group</li>
     * </ul>
     * <h3>Searching for Timestamp Fields</h3>
     * <p>All timestamp fields (created_at, updated_at etc.) are indexed as Dates for Contact Search queries; Datetime queries are not currently supported. This means you can only query for timestamp fields by day - not hour, minute or second.
     * For example, if you search for all Contacts with a created_at value greater (&gt;) than 1577869200 (the UNIX timestamp for January 1st, 2020 9:00 AM), that will be interpreted as 1577836800 (January 1st, 2020 12:00 AM). The search results will then include Contacts created from January 2nd, 2020 12:00 AM onwards.
     * If you'd like to get contacts created on January 1st, 2020 you should search with a created_at value equal (=) to 1577836800 (January 1st, 2020 12:00 AM).
     * This behaviour applies only to timestamps used in search queries. The search results will still contain the full UNIX timestamp and be sorted accordingly.</p>
     * <h3>Accepted Fields</h3>
     * <p>Most key listed as part of the Contacts Model are searchable, whether writeable or not. The value you search for has to match the accepted type, otherwise the query will fail (ie. as <code>created_at</code> accepts a date, the <code>value</code> cannot be a string such as <code>&quot;foorbar&quot;</code>).</p>
     * <p>| Field                              | Type                           |
     * | ---------------------------------- | ------------------------------ |
     * | id                                 | String                         |
     * | role                               | String&lt;br&gt;Accepts user or lead |
     * | name                               | String                         |
     * | avatar                             | String                         |
     * | owner_id                           | Integer                        |
     * | email                              | String                         |
     * | email_domain                       | String                         |
     * | phone                              | String                         |
     * | formatted_phone                    | String                         |
     * | external_id                        | String                         |
     * | created_at                         | Date (UNIX Timestamp)          |
     * | signed_up_at                       | Date (UNIX Timestamp)          |
     * | updated_at                         | Date (UNIX Timestamp)          |
     * | last_seen_at                       | Date (UNIX Timestamp)          |
     * | last_contacted_at                  | Date (UNIX Timestamp)          |
     * | last_replied_at                    | Date (UNIX Timestamp)          |
     * | last_email_opened_at               | Date (UNIX Timestamp)          |
     * | last_email_clicked_at              | Date (UNIX Timestamp)          |
     * | language_override                  | String                         |
     * | browser                            | String                         |
     * | browser_language                   | String                         |
     * | os                                 | String                         |
     * | location.country                   | String                         |
     * | location.region                    | String                         |
     * | location.city                      | String                         |
     * | unsubscribed_from_emails           | Boolean                        |
     * | marked_email_as_spam               | Boolean                        |
     * | has_hard_bounced                   | Boolean                        |
     * | ios_last_seen_at                   | Date (UNIX Timestamp)          |
     * | ios_app_version                    | String                         |
     * | ios_device                         | String                         |
     * | ios_app_device                     | String                         |
     * | ios_os_version                     | String                         |
     * | ios_app_name                       | String                         |
     * | ios_sdk_version                    | String                         |
     * | android_last_seen_at               | Date (UNIX Timestamp)          |
     * | android_app_version                | String                         |
     * | android_device                     | String                         |
     * | android_app_name                   | String                         |
     * | andoid_sdk_version                 | String                         |
     * | segment_id                         | String                         |
     * | tag_id                             | String                         |
     * | custom_attributes.{attribute_name} | String                         |</p>
     * <h3>Accepted Operators</h3>
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Searching based on <code>created_at</code>&quot; %}
     * You cannot use the <code>&lt;=</code> or <code>&gt;=</code> operators to search by <code>created_at</code>.
     * {% /admonition %}</p>
     * <p>The table below shows the operators you can use to define how you want to search for the value.  The operator should be put in as a string (<code>&quot;=&quot;</code>). The operator has to be compatible with the field's type (eg. you cannot search with <code>&gt;</code> for a given string value as it's only compatible for integer's and dates).</p>
     * <p>| Operator | Valid Types                      | Description                                                      |
     * | :------- | :------------------------------- | :--------------------------------------------------------------- |
     * | =        | All                              | Equals                                                           |
     * | !=       | All                              | Doesn't Equal                                                    |
     * | IN       | All                              | In&lt;br&gt;Shortcut for <code>OR</code> queries&lt;br&gt;Values must be in Array       |
     * | NIN      | All                              | Not In&lt;br&gt;Shortcut for <code>OR !</code> queries&lt;br&gt;Values must be in Array |
     * | &gt;        | Integer&lt;br&gt;Date (UNIX Timestamp) | Greater than                                                     |
     * | &lt;       | Integer&lt;br&gt;Date (UNIX Timestamp) | Lower than                                                       |
     * | ~        | String                           | Contains                                                         |
     * | !~       | String                           | Doesn't Contain                                                  |
     * | ^        | String                           | Starts With                                                      |
     * | $        | String                           | Ends With                                                        |</p>
     */
    public CompletableFuture<ContactList> searchContacts(SearchRequest request, RequestOptions requestOptions) {
        return this.rawClient.searchContacts(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of all contacts (ie. users or leads) in your workspace.
     * {% admonition type=&quot;warning&quot; name=&quot;Pagination&quot; %}
     * You can use pagination to limit the number of results returned. The default is <code>50</code> results per page.
     * See the <a href="https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#pagination-for-list-apis">pagination section</a> for more details on how to use the <code>starting_after</code> param.
     * {% /admonition %}
     */
    public CompletableFuture<ContactList> listContacts() {
        return this.rawClient.listContacts().thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of all contacts (ie. users or leads) in your workspace.
     * {% admonition type=&quot;warning&quot; name=&quot;Pagination&quot; %}
     * You can use pagination to limit the number of results returned. The default is <code>50</code> results per page.
     * See the <a href="https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#pagination-for-list-apis">pagination section</a> for more details on how to use the <code>starting_after</code> param.
     * {% /admonition %}
     */
    public CompletableFuture<ContactList> listContacts(RequestOptions requestOptions) {
        return this.rawClient.listContacts(requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can create a new contact (ie. user or lead).
     */
    public CompletableFuture<CreateContactResponse> createContact(Object request) {
        return this.rawClient.createContact(request).thenApply(response -> response.body());
    }

    /**
     * You can create a new contact (ie. user or lead).
     */
    public CompletableFuture<CreateContactResponse> createContact(Object request, RequestOptions requestOptions) {
        return this.rawClient.createContact(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of a single contact by external ID. Note that this endpoint only supports users and not leads.
     */
    public CompletableFuture<ShowContactByExternalIdResponse> showContactByExternalId(
            ShowContactByExternalIdRequest request) {
        return this.rawClient.showContactByExternalId(request).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of a single contact by external ID. Note that this endpoint only supports users and not leads.
     */
    public CompletableFuture<ShowContactByExternalIdResponse> showContactByExternalId(
            ShowContactByExternalIdRequest request, RequestOptions requestOptions) {
        return this.rawClient.showContactByExternalId(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can archive a single contact.
     */
    public CompletableFuture<ContactArchived> archiveContact(ArchiveContactRequest request) {
        return this.rawClient.archiveContact(request).thenApply(response -> response.body());
    }

    /**
     * You can archive a single contact.
     */
    public CompletableFuture<ContactArchived> archiveContact(
            ArchiveContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.archiveContact(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can unarchive a single contact.
     */
    public CompletableFuture<ContactUnarchived> unarchiveContact(UnarchiveContactRequest request) {
        return this.rawClient.unarchiveContact(request).thenApply(response -> response.body());
    }

    /**
     * You can unarchive a single contact.
     */
    public CompletableFuture<ContactUnarchived> unarchiveContact(
            UnarchiveContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.unarchiveContact(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Block a single contact.&lt;br&gt;<strong>Note:</strong> conversations of the contact will also be archived during the process.&lt;br&gt;More details in <a href="https://www.intercom.com/help/en/articles/8838656-inbox-faqs">FAQ How do I block Inbox spam?</a>
     */
    public CompletableFuture<ContactBlocked> blockContact(BlockContactRequest request) {
        return this.rawClient.blockContact(request).thenApply(response -> response.body());
    }

    /**
     * Block a single contact.&lt;br&gt;<strong>Note:</strong> conversations of the contact will also be archived during the process.&lt;br&gt;More details in <a href="https://www.intercom.com/help/en/articles/8838656-inbox-faqs">FAQ How do I block Inbox spam?</a>
     */
    public CompletableFuture<ContactBlocked> blockContact(BlockContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.blockContact(request, requestOptions).thenApply(response -> response.body());
    }
}
