/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.contacts.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ShowContactByExternalIdRequest.Builder.class)
public final class ShowContactByExternalIdRequest {
    private final String externalId;

    private final Map<String, Object> additionalProperties;

    private ShowContactByExternalIdRequest(String externalId, Map<String, Object> additionalProperties) {
        this.externalId = externalId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The external ID of the user that you want to retrieve
     */
    @JsonProperty("external_id")
    public String getExternalId() {
        return externalId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ShowContactByExternalIdRequest && equalTo((ShowContactByExternalIdRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ShowContactByExternalIdRequest other) {
        return externalId.equals(other.externalId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.externalId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ExternalIdStage builder() {
        return new Builder();
    }

    public interface ExternalIdStage {
        /**
         * <p>The external ID of the user that you want to retrieve</p>
         */
        _FinalStage externalId(@NotNull String externalId);

        Builder from(ShowContactByExternalIdRequest other);
    }

    public interface _FinalStage {
        ShowContactByExternalIdRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements ExternalIdStage, _FinalStage {
        private String externalId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ShowContactByExternalIdRequest other) {
            externalId(other.getExternalId());
            return this;
        }

        /**
         * <p>The external ID of the user that you want to retrieve</p>
         * <p>The external ID of the user that you want to retrieve</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("external_id")
        public _FinalStage externalId(@NotNull String externalId) {
            this.externalId = Objects.requireNonNull(externalId, "externalId must not be null");
            return this;
        }

        @java.lang.Override
        public ShowContactByExternalIdRequest build() {
            return new ShowContactByExternalIdRequest(externalId, additionalProperties);
        }
    }
}
