/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.dataexport.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = DataExport.Builder.class)
public final class DataExport {
    private final Optional<String> jobIdentfier;

    private final Optional<Status> status;

    private final Optional<String> downloadExpiresAt;

    private final Optional<String> downloadUrl;

    private final Map<String, Object> additionalProperties;

    private DataExport(
            Optional<String> jobIdentfier,
            Optional<Status> status,
            Optional<String> downloadExpiresAt,
            Optional<String> downloadUrl,
            Map<String, Object> additionalProperties) {
        this.jobIdentfier = jobIdentfier;
        this.status = status;
        this.downloadExpiresAt = downloadExpiresAt;
        this.downloadUrl = downloadUrl;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The identifier for your job.
     */
    @JsonProperty("job_identfier")
    public Optional<String> getJobIdentfier() {
        return jobIdentfier;
    }

    /**
     * @return The current state of your job.
     */
    @JsonProperty("status")
    public Optional<Status> getStatus() {
        return status;
    }

    /**
     * @return The time after which you will not be able to access the data.
     */
    @JsonProperty("download_expires_at")
    public Optional<String> getDownloadExpiresAt() {
        return downloadExpiresAt;
    }

    /**
     * @return The location where you can download your data.
     */
    @JsonProperty("download_url")
    public Optional<String> getDownloadUrl() {
        return downloadUrl;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof DataExport && equalTo((DataExport) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DataExport other) {
        return jobIdentfier.equals(other.jobIdentfier)
                && status.equals(other.status)
                && downloadExpiresAt.equals(other.downloadExpiresAt)
                && downloadUrl.equals(other.downloadUrl);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.jobIdentfier, this.status, this.downloadExpiresAt, this.downloadUrl);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> jobIdentfier = Optional.empty();

        private Optional<Status> status = Optional.empty();

        private Optional<String> downloadExpiresAt = Optional.empty();

        private Optional<String> downloadUrl = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(DataExport other) {
            jobIdentfier(other.getJobIdentfier());
            status(other.getStatus());
            downloadExpiresAt(other.getDownloadExpiresAt());
            downloadUrl(other.getDownloadUrl());
            return this;
        }

        /**
         * <p>The identifier for your job.</p>
         */
        @JsonSetter(value = "job_identfier", nulls = Nulls.SKIP)
        public Builder jobIdentfier(Optional<String> jobIdentfier) {
            this.jobIdentfier = jobIdentfier;
            return this;
        }

        public Builder jobIdentfier(String jobIdentfier) {
            this.jobIdentfier = Optional.ofNullable(jobIdentfier);
            return this;
        }

        /**
         * <p>The current state of your job.</p>
         */
        @JsonSetter(value = "status", nulls = Nulls.SKIP)
        public Builder status(Optional<Status> status) {
            this.status = status;
            return this;
        }

        public Builder status(Status status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        /**
         * <p>The time after which you will not be able to access the data.</p>
         */
        @JsonSetter(value = "download_expires_at", nulls = Nulls.SKIP)
        public Builder downloadExpiresAt(Optional<String> downloadExpiresAt) {
            this.downloadExpiresAt = downloadExpiresAt;
            return this;
        }

        public Builder downloadExpiresAt(String downloadExpiresAt) {
            this.downloadExpiresAt = Optional.ofNullable(downloadExpiresAt);
            return this;
        }

        /**
         * <p>The location where you can download your data.</p>
         */
        @JsonSetter(value = "download_url", nulls = Nulls.SKIP)
        public Builder downloadUrl(Optional<String> downloadUrl) {
            this.downloadUrl = downloadUrl;
            return this;
        }

        public Builder downloadUrl(String downloadUrl) {
            this.downloadUrl = Optional.ofNullable(downloadUrl);
            return this;
        }

        public DataExport build() {
            return new DataExport(jobIdentfier, status, downloadExpiresAt, downloadUrl, additionalProperties);
        }
    }

    public static final class Status {
        public static final Status FAILED = new Status(Value.FAILED, "failed");

        public static final Status COMPLETED = new Status(Value.COMPLETED, "completed");

        public static final Status NO_DATA = new Status(Value.NO_DATA, "no_data");

        public static final Status PENDING = new Status(Value.PENDING, "pending");

        public static final Status IN_PROGRESS = new Status(Value.IN_PROGRESS, "in_progress");

        public static final Status CANCELED = new Status(Value.CANCELED, "canceled");

        private final Value value;

        private final String string;

        Status(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof Status && this.string.equals(((Status) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case FAILED:
                    return visitor.visitFailed();
                case COMPLETED:
                    return visitor.visitCompleted();
                case NO_DATA:
                    return visitor.visitNoData();
                case PENDING:
                    return visitor.visitPending();
                case IN_PROGRESS:
                    return visitor.visitInProgress();
                case CANCELED:
                    return visitor.visitCanceled();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static Status valueOf(String value) {
            switch (value) {
                case "failed":
                    return FAILED;
                case "completed":
                    return COMPLETED;
                case "no_data":
                    return NO_DATA;
                case "pending":
                    return PENDING;
                case "in_progress":
                    return IN_PROGRESS;
                case "canceled":
                    return CANCELED;
                default:
                    return new Status(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            PENDING,

            IN_PROGRESS,

            FAILED,

            COMPLETED,

            NO_DATA,

            CANCELED,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitPending();

            T visitInProgress();

            T visitFailed();

            T visitCompleted();

            T visitNoData();

            T visitCanceled();

            T visitUnknown(String unknownType);
        }
    }
}
