/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.helpcenter;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.helpcenter.requests.CreateCollectionRequest;
import com.intercom.api.resources.unstable.helpcenter.requests.DeleteCollectionRequest;
import com.intercom.api.resources.unstable.helpcenter.requests.RetrieveCollectionRequest;
import com.intercom.api.resources.unstable.helpcenter.requests.RetrieveHelpCenterRequest;
import com.intercom.api.resources.unstable.helpcenter.requests.UpdateCollectionRequest;
import com.intercom.api.resources.unstable.helpcenter.types.Collection;
import com.intercom.api.resources.unstable.helpcenter.types.HelpCenter;
import com.intercom.api.resources.unstable.helpcenter.types.HelpCenterList;
import com.intercom.api.resources.unstable.types.CollectionList;
import com.intercom.api.resources.unstable.types.DeletedCollectionObject;
import java.util.concurrent.CompletableFuture;

public class AsyncHelpCenterClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawHelpCenterClient rawClient;

    public AsyncHelpCenterClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawHelpCenterClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawHelpCenterClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can fetch a list of all collections by making a GET request to <code>https://api.intercom.io/help_center/collections</code>.
     * <p>Collections will be returned in descending order on the <code>updated_at</code> attribute. This means if you need to iterate through results then we'll show the most recently updated collections first.</p>
     */
    public CompletableFuture<CollectionList> listAllCollections() {
        return this.rawClient.listAllCollections().thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of all collections by making a GET request to <code>https://api.intercom.io/help_center/collections</code>.
     * <p>Collections will be returned in descending order on the <code>updated_at</code> attribute. This means if you need to iterate through results then we'll show the most recently updated collections first.</p>
     */
    public CompletableFuture<CollectionList> listAllCollections(RequestOptions requestOptions) {
        return this.rawClient.listAllCollections(requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can create a new collection by making a POST request to <code>https://api.intercom.io/help_center/collections.</code>
     */
    public CompletableFuture<Collection> createCollection(CreateCollectionRequest request) {
        return this.rawClient.createCollection(request).thenApply(response -> response.body());
    }

    /**
     * You can create a new collection by making a POST request to <code>https://api.intercom.io/help_center/collections.</code>
     */
    public CompletableFuture<Collection> createCollection(
            CreateCollectionRequest request, RequestOptions requestOptions) {
        return this.rawClient.createCollection(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of a single collection by making a GET request to <code>https://api.intercom.io/help_center/collections/&lt;id&gt;</code>.
     */
    public CompletableFuture<Collection> retrieveCollection(RetrieveCollectionRequest request) {
        return this.rawClient.retrieveCollection(request).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of a single collection by making a GET request to <code>https://api.intercom.io/help_center/collections/&lt;id&gt;</code>.
     */
    public CompletableFuture<Collection> retrieveCollection(
            RetrieveCollectionRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveCollection(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can update the details of a single collection by making a PUT request to <code>https://api.intercom.io/collections/&lt;id&gt;</code>.
     */
    public CompletableFuture<Collection> updateCollection(UpdateCollectionRequest request) {
        return this.rawClient.updateCollection(request).thenApply(response -> response.body());
    }

    /**
     * You can update the details of a single collection by making a PUT request to <code>https://api.intercom.io/collections/&lt;id&gt;</code>.
     */
    public CompletableFuture<Collection> updateCollection(
            UpdateCollectionRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateCollection(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can delete a single collection by making a DELETE request to <code>https://api.intercom.io/collections/&lt;id&gt;</code>.
     */
    public CompletableFuture<DeletedCollectionObject> deleteCollection(DeleteCollectionRequest request) {
        return this.rawClient.deleteCollection(request).thenApply(response -> response.body());
    }

    /**
     * You can delete a single collection by making a DELETE request to <code>https://api.intercom.io/collections/&lt;id&gt;</code>.
     */
    public CompletableFuture<DeletedCollectionObject> deleteCollection(
            DeleteCollectionRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteCollection(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of a single Help Center by making a GET request to <code>https://api.intercom.io/help_center/help_center/&lt;id&gt;</code>.
     */
    public CompletableFuture<HelpCenter> retrieveHelpCenter(RetrieveHelpCenterRequest request) {
        return this.rawClient.retrieveHelpCenter(request).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of a single Help Center by making a GET request to <code>https://api.intercom.io/help_center/help_center/&lt;id&gt;</code>.
     */
    public CompletableFuture<HelpCenter> retrieveHelpCenter(
            RetrieveHelpCenterRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveHelpCenter(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can list all Help Centers by making a GET request to <code>https://api.intercom.io/help_center/help_centers</code>.
     */
    public CompletableFuture<HelpCenterList> listHelpCenters() {
        return this.rawClient.listHelpCenters().thenApply(response -> response.body());
    }

    /**
     * You can list all Help Centers by making a GET request to <code>https://api.intercom.io/help_center/help_centers</code>.
     */
    public CompletableFuture<HelpCenterList> listHelpCenters(RequestOptions requestOptions) {
        return this.rawClient.listHelpCenters(requestOptions).thenApply(response -> response.body());
    }
}
